DROP TABLE IF EXISTS wp56_commentmeta;

CREATE TABLE `wp56_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS wp56_comments;

CREATE TABLE `wp56_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO wp56_comments VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2018-08-07 16:07:46", "2018-08-07 16:07:46", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "post-trashed", "", "", "0", "0");

DROP TABLE IF EXISTS wp56_duplicator_packages;

CREATE TABLE `wp56_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wp56_links;

CREATE TABLE `wp56_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS wp56_options;

CREATE TABLE `wp56_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=747 DEFAULT CHARSET=utf8;

INSERT INTO wp56_options VALUES("1", "siteurl", "https://murrysvilledeals.com", "yes");
INSERT INTO wp56_options VALUES("2", "home", "https://murrysvilledeals.com", "yes");
INSERT INTO wp56_options VALUES("3", "blogname", "My Blog", "yes");
INSERT INTO wp56_options VALUES("4", "blogdescription", "My WordPress Blog", "yes");
INSERT INTO wp56_options VALUES("5", "users_can_register", "0", "yes");
INSERT INTO wp56_options VALUES("6", "admin_email", "admin@child.mymurrysville.com", "yes");
INSERT INTO wp56_options VALUES("7", "start_of_week", "1", "yes");
INSERT INTO wp56_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wp56_options VALUES("9", "use_smilies", "1", "yes");
INSERT INTO wp56_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wp56_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wp56_options VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO wp56_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wp56_options VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO wp56_options VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO wp56_options VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO wp56_options VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO wp56_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wp56_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wp56_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wp56_options VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO wp56_options VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO wp56_options VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO wp56_options VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO wp56_options VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO wp56_options VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO wp56_options VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO wp56_options VALUES("28", "permalink_structure", "/{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}postname{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}/", "yes");
INSERT INTO wp56_options VALUES("29", "rewrite_rules", "a:289:{s:28:\"event-aggregator/(insert)/?$\";s:53:\"index.php?tribe-aggregator=1&tribe-action=$matches[1]\";s:25:\"(?:event)/([^/]+)/ical/?$\";s:56:\"index.php?ical=1&name=$matches[1]&post_type=tribe_events\";s:28:\"(?:events)/(?:page)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:41:\"(?:events)/(?:featured)/(?:page)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&paged=$matches[1]\";s:38:\"(?:events)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=tribe_events&eventDisplay=list&feed=$matches[1]\";s:51:\"(?:events)/(?:featured)/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&feed=$matches[1]\";s:23:\"(?:events)/(?:month)/?$\";s:51:\"index.php?post_type=tribe_events&eventDisplay=month\";s:36:\"(?:events)/(?:month)/(?:featured)/?$\";s:62:\"index.php?post_type=tribe_events&eventDisplay=month&featured=1\";s:37:\"(?:events)/(?:month)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:37:\"(?:events)/(?:list)/(?:page)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:50:\"(?:events)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1&paged=$matches[1]\";s:22:\"(?:events)/(?:list)/?$\";s:50:\"index.php?post_type=tribe_events&eventDisplay=list\";s:35:\"(?:events)/(?:list)/(?:featured)/?$\";s:61:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1\";s:23:\"(?:events)/(?:today)/?$\";s:49:\"index.php?post_type=tribe_events&eventDisplay=day\";s:36:\"(?:events)/(?:today)/(?:featured)/?$\";s:60:\"index.php?post_type=tribe_events&eventDisplay=day&featured=1\";s:27:\"(?:events)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:40:\"(?:events)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:84:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]&featured=1\";s:33:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]\";s:46:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:82:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:26:\"(?:events)/(?:featured)/?$\";s:43:\"index.php?post_type=tribe_events&featured=1\";s:13:\"(?:events)/?$\";s:53:\"index.php?post_type=tribe_events&eventDisplay=default\";s:18:\"(?:events)/ical/?$\";s:39:\"index.php?post_type=tribe_events&ical=1\";s:31:\"(?:events)/(?:featured)/ical/?$\";s:50:\"index.php?post_type=tribe_events&ical=1&featured=1\";s:38:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/ical/?$\";s:78:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]\";s:47:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/ical/featured/?$\";s:89:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:60:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:73:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/(?:page)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:55:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:month)/?$\";s:80:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month\";s:68:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:month)/(?:featured)/?$\";s:91:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&featured=1\";s:69:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:82:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:54:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list\";s:67:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:featured)/?$\";s:90:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1\";s:55:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:today)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day\";s:68:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:today)/(?:featured)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&featured=1\";s:73:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:86:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:59:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/?$\";s:102:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:72:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:113:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:65:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:78:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:50:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/feed/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&feed=rss2\";s:63:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/feed/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&feed=rss2\";s:50:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/ical/?$\";s:68:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&ical=1\";s:63:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/ical/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&ical=1\";s:75:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&feed=$matches[2]\";s:88:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&feed=$matches[2]\";s:58:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/?$\";s:93:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=default\";s:45:\"(?:events)/(?:category)/(?:[^/]+/)*([^/]+)/?$\";s:82:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=default\";s:44:\"(?:events)/(?:tag)/([^/]+)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:57:\"(?:events)/(?:tag)/([^/]+)/(?:featured)/(?:page)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:39:\"(?:events)/(?:tag)/([^/]+)/(?:month)/?$\";s:67:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month\";s:52:\"(?:events)/(?:tag)/([^/]+)/(?:month)/(?:featured)/?$\";s:78:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&featured=1\";s:53:\"(?:events)/(?:tag)/([^/]+)/(?:list)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:66:\"(?:events)/(?:tag)/([^/]+)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:38:\"(?:events)/(?:tag)/([^/]+)/(?:list)/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list\";s:51:\"(?:events)/(?:tag)/([^/]+)/(?:list)/(?:featured)/?$\";s:77:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1\";s:39:\"(?:events)/(?:tag)/([^/]+)/(?:today)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day\";s:52:\"(?:events)/(?:tag)/([^/]+)/(?:today)/(?:featured)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&featured=1\";s:57:\"(?:events)/(?:tag)/([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:70:\"(?:events)/(?:tag)/([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:43:\"(?:events)/(?:tag)/([^/]+)/(\\d{4}-\\d{2})/?$\";s:89:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:56:\"(?:events)/(?:tag)/([^/]+)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:100:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:49:\"(?:events)/(?:tag)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:62:\"(?:events)/(?:tag)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:34:\"(?:events)/(?:tag)/([^/]+)/feed/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2\";s:47:\"(?:events)/(?:tag)/([^/]+)/(?:featured)/feed/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2&featured=1\";s:34:\"(?:events)/(?:tag)/([^/]+)/ical/?$\";s:55:\"index.php?post_type=tribe_events&tag=$matches[1]&ical=1\";s:47:\"(?:events)/(?:tag)/([^/]+)/(?:featured)/ical/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&ical=1\";s:59:\"(?:events)/(?:tag)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&feed=$matches[2]\";s:72:\"(?:events)/(?:tag)/([^/]+)/(?:featured)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&feed=$matches[2]\";s:42:\"(?:events)/(?:tag)/([^/]+)/(?:featured)/?$\";s:59:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1\";s:29:\"(?:events)/(?:tag)/([^/]+)/?$\";s:69:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=default\";s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:8:\"event/?$\";s:32:\"index.php?post_type=tribe_events\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=tribe_events&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"layout/([^/]+)/embed/?$\";s:54:\"index.php?post_type=layout&name=$matches[1]&embed=true\";s:27:\"layout/([^/]+)/trackback/?$\";s:48:\"index.php?post_type=layout&name=$matches[1]&tb=1\";s:35:\"layout/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?post_type=layout&name=$matches[1]&paged=$matches[2]\";s:42:\"layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:61:\"index.php?post_type=layout&name=$matches[1]&cpage=$matches[2]\";s:31:\"layout/([^/]+)(?:/([0-9]+))?/?$\";s:60:\"index.php?post_type=layout&name=$matches[1]&page=$matches[2]\";s:23:\"layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:33:\"venue/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"venue/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"venue/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"venue/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"venue/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"venue/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"venue/([^/]+)/embed/?$\";s:44:\"index.php?tribe_venue=$matches[1]&embed=true\";s:26:\"venue/([^/]+)/trackback/?$\";s:38:\"index.php?tribe_venue=$matches[1]&tb=1\";s:34:\"venue/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&paged=$matches[2]\";s:41:\"venue/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&cpage=$matches[2]\";s:30:\"venue/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?tribe_venue=$matches[1]&page=$matches[2]\";s:22:\"venue/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"venue/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"venue/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"venue/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"venue/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"venue/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"organizer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"organizer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"organizer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"organizer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"organizer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"organizer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"organizer/([^/]+)/embed/?$\";s:48:\"index.php?tribe_organizer=$matches[1]&embed=true\";s:30:\"organizer/([^/]+)/trackback/?$\";s:42:\"index.php?tribe_organizer=$matches[1]&tb=1\";s:38:\"organizer/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&paged=$matches[2]\";s:45:\"organizer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&cpage=$matches[2]\";s:34:\"organizer/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tribe_organizer=$matches[1]&page=$matches[2]\";s:26:\"organizer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"organizer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"organizer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"organizer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"organizer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"organizer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:45:\"index.php?tribe_events=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:39:\"index.php?tribe_events=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?tribe_events=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"events/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:49:\"events/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:30:\"events/category/(.+?)/embed/?$\";s:49:\"index.php?tribe_events_cat=$matches[1]&embed=true\";s:42:\"events/category/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tribe_events_cat=$matches[1]&paged=$matches[2]\";s:24:\"events/category/(.+?)/?$\";s:38:\"index.php?tribe_events_cat=$matches[1]\";s:41:\"deleted_event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"deleted_event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"deleted_event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"deleted_event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"deleted_event/([^/]+)/embed/?$\";s:46:\"index.php?deleted_event=$matches[1]&embed=true\";s:34:\"deleted_event/([^/]+)/trackback/?$\";s:40:\"index.php?deleted_event=$matches[1]&tb=1\";s:42:\"deleted_event/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&paged=$matches[2]\";s:49:\"deleted_event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&cpage=$matches[2]\";s:38:\"deleted_event/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?deleted_event=$matches[1]&page=$matches[2]\";s:30:\"deleted_event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"deleted_event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"deleted_event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"deleted_event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO wp56_options VALUES("30", "hack_file", "0", "yes");
INSERT INTO wp56_options VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO wp56_options VALUES("32", "moderation_keys", "", "no");
INSERT INTO wp56_options VALUES("33", "active_plugins", "a:5:{i:0;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:43:\"the-events-calendar/the-events-calendar.php\";i:3;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:4;s:43:\"wp-event-aggregator/wp-event-aggregator.php\";}", "yes");
INSERT INTO wp56_options VALUES("34", "category_base", "", "yes");
INSERT INTO wp56_options VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO wp56_options VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO wp56_options VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO wp56_options VALUES("38", "default_email_category", "1", "yes");
INSERT INTO wp56_options VALUES("39", "recently_edited", "", "no");
INSERT INTO wp56_options VALUES("40", "template", "Extra", "yes");
INSERT INTO wp56_options VALUES("41", "stylesheet", "Your-Generated-Divi-child-theme-template-by-DiviCake", "yes");
INSERT INTO wp56_options VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO wp56_options VALUES("43", "blacklist_keys", "", "no");
INSERT INTO wp56_options VALUES("44", "comment_registration", "0", "yes");
INSERT INTO wp56_options VALUES("45", "html_type", "text/html", "yes");
INSERT INTO wp56_options VALUES("46", "use_trackback", "0", "yes");
INSERT INTO wp56_options VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO wp56_options VALUES("48", "db_version", "38590", "yes");
INSERT INTO wp56_options VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO wp56_options VALUES("50", "upload_path", "", "yes");
INSERT INTO wp56_options VALUES("51", "blog_public", "1", "yes");
INSERT INTO wp56_options VALUES("52", "default_link_category", "2", "yes");
INSERT INTO wp56_options VALUES("53", "show_on_front", "layout", "yes");
INSERT INTO wp56_options VALUES("54", "tag_base", "", "yes");
INSERT INTO wp56_options VALUES("55", "show_avatars", "1", "yes");
INSERT INTO wp56_options VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO wp56_options VALUES("57", "upload_url_path", "", "yes");
INSERT INTO wp56_options VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO wp56_options VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO wp56_options VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO wp56_options VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO wp56_options VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO wp56_options VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO wp56_options VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO wp56_options VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO wp56_options VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO wp56_options VALUES("67", "image_default_size", "", "yes");
INSERT INTO wp56_options VALUES("68", "image_default_align", "", "yes");
INSERT INTO wp56_options VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO wp56_options VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO wp56_options VALUES("71", "thread_comments", "1", "yes");
INSERT INTO wp56_options VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO wp56_options VALUES("73", "page_comments", "0", "yes");
INSERT INTO wp56_options VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO wp56_options VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO wp56_options VALUES("76", "comment_order", "asc", "yes");
INSERT INTO wp56_options VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wp56_options VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("81", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO wp56_options VALUES("82", "timezone_string", "", "yes");
INSERT INTO wp56_options VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO wp56_options VALUES("84", "page_on_front", "0", "yes");
INSERT INTO wp56_options VALUES("85", "default_post_format", "0", "yes");
INSERT INTO wp56_options VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO wp56_options VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wp56_options VALUES("88", "site_icon", "0", "yes");
INSERT INTO wp56_options VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO wp56_options VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO wp56_options VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO wp56_options VALUES("92", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO wp56_options VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO wp56_options VALUES("94", "wp56_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:101:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:30:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO wp56_options VALUES("95", "fresh_site", "0", "yes");
INSERT INTO wp56_options VALUES("96", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("97", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("98", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("99", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("100", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("101", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:3:{i:0;s:8:\"search-2\";i:1;s:21:\"et_social_followers-2\";i:2;s:26:\"tribe-events-list-widget-2\";}s:15:\"sidebar-project\";a:0:{}s:16:\"sidebar-footer-1\";a:0:{}s:16:\"sidebar-footer-2\";a:0:{}s:16:\"sidebar-footer-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO wp56_options VALUES("102", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("103", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("104", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("105", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("106", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("107", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("108", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("109", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("110", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("111", "cron", "a:9:{i:1534473745;a:1:{s:39:\"tribe_aggregator_process_insert_records\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"tribe-every15mins\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1534475266;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1534478866;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1534522632;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1534524867;a:2:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"et_builder_fonts_cron\";a:1:{s:32:\"552cbb9d6515dadbbc4718ad75114f08\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{s:8:\"interval\";s:5:\"daily\";}s:8:\"interval\";i:86400;}}}i:1534525944;a:1:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1534549114;a:1:{s:22:\"tribe_trash_event_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1536251608;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO wp56_options VALUES("112", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1533659607;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO wp56_options VALUES("116", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.9.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1534435719;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wp56_options VALUES("134", "can_compress_scripts", "0", "no");
INSERT INTO wp56_options VALUES("138", "current_theme", "My Local Town News &amp; Events", "yes");
INSERT INTO wp56_options VALUES("139", "theme_mods_Extra", "a:8:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:0:{}s:36:\"et_pb_extra_predefined_layouts_added\";s:2:\"on\";s:40:\"et_pb_extra_predefined_layouts_version_1\";s:2:\"on\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1533659628;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:15:\"sidebar-project\";a:0:{}s:16:\"sidebar-footer-1\";a:0:{}s:16:\"sidebar-footer-2\";a:0:{}s:16:\"sidebar-footer-4\";a:0:{}}}}", "yes");
INSERT INTO wp56_options VALUES("140", "theme_switched", "", "yes");
INSERT INTO wp56_options VALUES("145", "et_core_version", "3.11.1", "yes");
INSERT INTO wp56_options VALUES("147", "et_extra", "a:159:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:25:\"3_0_flush_rewrite_rules_2\";s:4:\"done\";s:12:\"facebook_url\";s:20:\"https://facebook.com\";s:11:\"twitter_url\";s:19:\"https://twitter.com\";s:13:\"instagram_url\";s:21:\"https://instagram.com\";s:32:\"extra_previous_installed_version\";s:0:\"\";s:30:\"extra_latest_installed_version\";s:6:\"2.11.1\";s:28:\"extra_skip_font_subset_force\";b:1;s:30:\"has_auto_assign_category_color\";b:1;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:31:\"extra_update_woocommerce_images\";b:1;s:27:\"extra_documentation_message\";s:9:\"triggered\";s:10:\"extra_logo\";s:83:\"https://murrysvilledeals.com/wp-content/uploads/2018/08/Copy-of-Ice-Cream-Party.png\";s:13:\"extra_favicon\";s:0:\"\";s:12:\"accent_color\";s:7:\"#c33131\";s:15:\"extra_fixed_nav\";s:2:\"on\";s:16:\"sidebar_location\";s:5:\"right\";s:28:\"woocommerce_sidebar_location\";s:5:\"right\";s:7:\"sidebar\";s:12:\"sidebar-main\";s:19:\"woocommerce_sidebar\";s:12:\"sidebar-main\";s:37:\"social_followers_transient_expiration\";s:4:\"3600\";s:18:\"show_facebook_icon\";s:2:\"on\";s:17:\"show_twitter_icon\";s:2:\"on\";s:20:\"show_googleplus_icon\";s:2:\"on\";s:19:\"show_pinterest_icon\";s:2:\"on\";s:16:\"show_tumblr_icon\";s:2:\"on\";s:21:\"show_stumbleupon_icon\";s:2:\"on\";s:19:\"show_instagram_icon\";s:2:\"on\";s:17:\"show_youtube_icon\";s:2:\"on\";s:18:\"show_dribbble_icon\";s:2:\"on\";s:13:\"show_rss_icon\";s:2:\"on\";s:14:\"googleplus_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:15:\"stumbleupon_url\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:12:\"dribbble_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:22:\"extra_archivenum_posts\";i:5;s:35:\"extra_woocommerce_archive_num_posts\";i:9;s:18:\"extra_catnum_posts\";i:5;s:21:\"extra_searchnum_posts\";i:5;s:18:\"extra_tagnum_posts\";i:5;s:17:\"extra_date_format\";s:6:\"M j, Y\";s:17:\"extra_use_excerpt\";s:5:\"false\";s:27:\"extra_responsive_shortcodes\";s:2:\"on\";s:34:\"extra_gf_enable_all_character_sets\";s:5:\"false\";s:17:\"extra_back_to_top\";s:5:\"false\";s:19:\"extra_smooth_scroll\";s:5:\"false\";s:28:\"extra_minify_combine_scripts\";s:2:\"on\";s:27:\"extra_minify_combine_styles\";s:2:\"on\";s:16:\"extra_custom_css\";s:0:\"\";s:22:\"extra_enable_dropdowns\";s:2:\"on\";s:15:\"extra_home_link\";s:2:\"on\";s:16:\"extra_sort_pages\";s:10:\"post_title\";s:16:\"extra_order_page\";s:3:\"asc\";s:23:\"extra_tiers_shown_pages\";i:3;s:33:\"extra_enable_dropdowns_categories\";s:2:\"on\";s:22:\"extra_categories_empty\";s:2:\"on\";s:28:\"extra_tiers_shown_categories\";i:3;s:14:\"extra_sort_cat\";s:4:\"name\";s:15:\"extra_order_cat\";s:3:\"asc\";s:21:\"extra_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:4:{s:4:\"page\";s:2:\"on\";s:4:\"post\";s:2:\"on\";s:7:\"project\";s:2:\"on\";s:12:\"tribe_events\";s:2:\"on\";}s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:15:\"extra_postinfo2\";a:5:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:12:\"rating_stars\";}s:23:\"extra_show_postcomments\";s:2:\"on\";s:21:\"extra_show_author_box\";s:2:\"on\";s:24:\"extra_show_related_posts\";s:2:\"on\";s:24:\"extra_show_pagescomments\";s:5:\"false\";s:15:\"extra_postinfo1\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:12:\"rating_stars\";}s:18:\"archive_list_style\";s:8:\"Standard\";s:20:\"extra_seo_home_title\";s:5:\"false\";s:26:\"extra_seo_home_description\";s:5:\"false\";s:23:\"extra_seo_home_keywords\";s:5:\"false\";s:24:\"extra_seo_home_canonical\";s:5:\"false\";s:24:\"extra_seo_home_titletext\";s:0:\"\";s:30:\"extra_seo_home_descriptiontext\";s:0:\"\";s:27:\"extra_seo_home_keywordstext\";s:0:\"\";s:19:\"extra_seo_home_type\";s:27:\"BlogName | Blog description\";s:23:\"extra_seo_home_separate\";s:3:\" | \";s:22:\"extra_seo_single_title\";s:5:\"false\";s:28:\"extra_seo_single_description\";s:5:\"false\";s:25:\"extra_seo_single_keywords\";s:5:\"false\";s:26:\"extra_seo_single_canonical\";s:5:\"false\";s:28:\"extra_seo_single_field_title\";s:9:\"seo_title\";s:34:\"extra_seo_single_field_description\";s:15:\"seo_description\";s:31:\"extra_seo_single_field_keywords\";s:12:\"seo_keywords\";s:21:\"extra_seo_single_type\";s:21:\"Post title | BlogName\";s:25:\"extra_seo_single_separate\";s:3:\" | \";s:25:\"extra_seo_index_canonical\";s:5:\"false\";s:27:\"extra_seo_index_description\";s:5:\"false\";s:20:\"extra_seo_index_type\";s:24:\"Category name | BlogName\";s:24:\"extra_seo_index_separate\";s:3:\" | \";s:29:\"extra_integrate_header_enable\";s:2:\"on\";s:27:\"extra_integrate_body_enable\";s:2:\"on\";s:32:\"extra_integrate_singletop_enable\";s:2:\"on\";s:35:\"extra_integrate_singlebottom_enable\";s:2:\"on\";s:22:\"extra_integration_head\";s:0:\"\";s:22:\"extra_integration_body\";s:0:\"\";s:28:\"extra_integration_single_top\";s:0:\"\";s:31:\"extra_integration_single_bottom\";s:0:\"\";s:16:\"header_ad_enable\";s:5:\"false\";s:15:\"header_ad_image\";s:0:\"\";s:13:\"header_ad_url\";s:0:\"\";s:17:\"header_ad_adsense\";s:0:\"\";s:35:\"header_responsive_adsense_ad_enable\";s:5:\"false\";s:22:\"header_below_ad_enable\";s:5:\"false\";s:21:\"header_below_ad_image\";s:0:\"\";s:19:\"header_below_ad_url\";s:0:\"\";s:23:\"header_below_ad_adsense\";s:0:\"\";s:41:\"header_below_responsive_adsense_ad_enable\";s:5:\"false\";s:22:\"footer_above_ad_enable\";s:5:\"false\";s:21:\"footer_above_ad_image\";s:0:\"\";s:19:\"footer_above_ad_url\";s:0:\"\";s:23:\"footer_above_ad_adsense\";s:0:\"\";s:41:\"footer_above_responsive_adsense_ad_enable\";s:5:\"false\";s:20:\"post_below_ad_enable\";s:5:\"false\";s:19:\"post_below_ad_image\";s:0:\"\";s:17:\"post_below_ad_url\";s:0:\"\";s:21:\"post_below_ad_adsense\";s:0:\"\";s:39:\"post_below_responsive_adsense_ad_enable\";s:5:\"false\";s:20:\"post_above_ad_enable\";s:5:\"false\";s:19:\"post_above_ad_image\";s:0:\"\";s:17:\"post_above_ad_url\";s:0:\"\";s:21:\"post_above_ad_adsense\";s:0:\"\";s:39:\"post_above_responsive_adsense_ad_enable\";s:5:\"false\";s:17:\"social_follow_api\";a:14:{s:11:\"facebook_id\";s:0:\"\";s:15:\"facebook_secret\";s:0:\"\";s:18:\"googleplus_api_key\";s:0:\"\";s:15:\"youtube_api_key\";s:0:\"\";s:19:\"tumblr_consumer_key\";s:0:\"\";s:22:\"tumblr_consumer_secret\";s:0:\"\";s:19:\"tumblr_access_token\";s:0:\"\";s:26:\"tumblr_access_token_secret\";s:0:\"\";s:15:\"twitter_api_key\";s:0:\"\";s:18:\"twitter_api_secret\";s:0:\"\";s:13:\"twitter_token\";s:0:\"\";s:20:\"twitter_token_secret\";s:0:\"\";s:12:\"instagram_id\";s:0:\"\";s:16:\"instagram_secret\";s:0:\"\";}s:19:\"product_tour_status\";a:1:{i:1;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:5:\"false\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:400;s:33:\"et_fb_pref_modal_dimension_height\";i:400;s:27:\"et_fb_pref_modal_position_x\";i:741;s:27:\"et_fb_pref_modal_position_y\";i:67;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:27:\"et_pb_clear_templates_cache\";b:1;}", "yes");
INSERT INTO wp56_options VALUES("148", "widget_et_social_followers", "a:2:{i:2;a:36:{s:5:\"title\";s:9:\"Follow Us\";s:16:\"facebook-enabled\";b:1;s:12:\"facebook-url\";s:19:\"http://facebook.com\";s:13:\"facebook-name\";s:0:\"\";s:11:\"facebook-id\";s:0:\"\";s:15:\"facebook-secret\";s:0:\"\";s:18:\"googleplus-enabled\";b:1;s:14:\"googleplus-url\";s:0:\"\";s:17:\"googleplus-userId\";s:0:\"\";s:18:\"googleplus-api_key\";s:0:\"\";s:15:\"youtube-enabled\";b:1;s:11:\"youtube-url\";s:18:\"http://youtube.com\";s:16:\"youtube-username\";s:0:\"\";s:15:\"youtube-api_key\";s:0:\"\";s:13:\"vimeo-enabled\";b:1;s:9:\"vimeo-url\";s:0:\"\";s:18:\"vimeo-channel_name\";s:0:\"\";s:14:\"tumblr-enabled\";b:1;s:10:\"tumblr-url\";s:0:\"\";s:19:\"tumblr-consumer_key\";s:0:\"\";s:22:\"tumblr-consumer_secret\";s:0:\"\";s:19:\"tumblr-access_token\";s:0:\"\";s:26:\"tumblr-access_token_secret\";s:0:\"\";s:15:\"twitter-enabled\";b:1;s:11:\"twitter-url\";s:18:\"http://twitter.com\";s:15:\"twitter-api_key\";s:0:\"\";s:18:\"twitter-api_secret\";s:0:\"\";s:13:\"twitter-token\";s:0:\"\";s:20:\"twitter-token_secret\";s:0:\"\";s:17:\"pinterest-enabled\";b:1;s:13:\"pinterest-url\";s:0:\"\";s:14:\"pinterest-name\";s:0:\"\";s:17:\"instagram-enabled\";b:1;s:13:\"instagram-url\";s:20:\"Http://instagram.com\";s:12:\"instagram-id\";s:0:\"\";s:16:\"instagram-secret\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("149", "widget_et_recent_tweets", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("150", "widget_et_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("151", "widget_et_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("152", "widget_et_ads", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("153", "et_taxonomy_meta", "a:1:{i:1;a:1:{i:0;a:1:{s:5:\"color\";s:7:\"#7ac8cc\";}}}", "yes");
INSERT INTO wp56_options VALUES("154", "et_images_temp_folder", "/home/murrysv3/public_html/child/wp-content/uploads/et_temp", "yes");
INSERT INTO wp56_options VALUES("155", "et_schedule_clean_images_last_time", "1534266255", "yes");
INSERT INTO wp56_options VALUES("156", "et_pb_builder_options", "a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}", "yes");
INSERT INTO wp56_options VALUES("157", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"440\";s:6:\"height\";s:3:\"440\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("158", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"627\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO wp56_options VALUES("159", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"192\";s:6:\"height\";s:3:\"192\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("160", "_site_transient_et_update_all_plugins", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1534370457;}", "no");
INSERT INTO wp56_options VALUES("162", "_site_transient_et_update_themes", "O:8:\"stdClass\":3:{s:7:\"checked\";a:5:{s:5:\"Extra\";s:6:\"2.11.1\";s:52:\"Your-Generated-Divi-child-theme-template-by-DiviCake\";s:3:\"1.0\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:1:{s:5:\"Extra\";a:2:{s:11:\"new_version\";s:6:\"2.12.1\";s:3:\"url\";s:53:\"https://www.elegantthemes.com/api/changelog/extra.txt\";}}s:12:\"last_checked\";i:1534370451;}", "no");
INSERT INTO wp56_options VALUES("167", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1534435719;s:7:\"checked\";a:5:{s:5:\"Extra\";s:6:\"2.11.1\";s:52:\"Your-Generated-Divi-child-theme-template-by-DiviCake\";s:3:\"1.0\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wp56_options VALUES("169", "theme_mods_Your-Generated-Divi-child-theme-template-by-DiviCake", "a:7:{i:0;b:0;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}s:36:\"et_pb_extra_predefined_layouts_added\";s:2:\"on\";s:40:\"et_pb_extra_predefined_layouts_version_1\";s:2:\"on\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:18:\"custom_css_post_id\";i:26;}", "yes");
INSERT INTO wp56_options VALUES("176", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";s:16:\"use_google_fonts\";s:2:\"on\";}", "yes");
INSERT INTO wp56_options VALUES("177", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:0:\"\";s:7:\"api_key\";s:0:\"\";}", "no");
INSERT INTO wp56_options VALUES("180", "recently_activated", "a:0:{}", "yes");
INSERT INTO wp56_options VALUES("195", "wpclone_directory_scan", "a:4:{s:6:\"dbsize\";s:7:\"2.06 MB\";s:4:\"size\";s:8:\"199.3 MB\";s:5:\"files\";i:5946;s:4:\"time\";i:1534473499;}", "yes");
INSERT INTO wp56_options VALUES("196", "wpclone_backups", "a:1:{i:1533661875;a:4:{s:4:\"name\";s:55:\"wpclone_backup_07th_Aug_2018_05-11PM_MyB_JitaVPvbwO.zip\";s:3:\"log\";s:55:\"wpclone_backup_07th_Aug_2018_05-11PM_MyB_JitaVPvbwO.log\";s:7:\"creator\";s:8:\"davecala\";s:4:\"size\";i:9244816;}}", "yes");
INSERT INTO wp56_options VALUES("209", "tribe_events_calendar_options", "a:37:{s:14:\"schema-version\";s:6:\"4.6.21\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:21:\"previous_ecp_versions\";a:1:{i:0;s:1:\"0\";}s:18:\"latest_ecp_version\";s:6:\"4.6.21\";s:39:\"last-update-message-the-events-calendar\";s:6:\"4.6.21\";s:11:\"donate-link\";b:0;s:12:\"postsPerPage\";s:2:\"10\";s:17:\"liveFiltersUpdate\";b:1;s:12:\"showComments\";b:0;s:20:\"showEventsInMainLoop\";b:1;s:10:\"eventsSlug\";s:6:\"events\";s:15:\"singleEventSlug\";s:5:\"event\";s:14:\"multiDayCutoff\";s:5:\"00:00\";s:21:\"defaultCurrencySymbol\";s:1:\"$\";s:23:\"reverseCurrencyPosition\";b:0;s:17:\"trash-past-events\";s:1:\"6\";s:18:\"delete-past-events\";s:0:\"\";s:15:\"embedGoogleMaps\";b:1;s:19:\"embedGoogleMapsZoom\";s:2:\"10\";s:11:\"debugEvents\";b:0;s:26:\"tribe_events_timezone_mode\";s:5:\"event\";s:32:\"tribe_events_timezones_show_zone\";b:0;s:16:\"stylesheetOption\";s:5:\"tribe\";s:19:\"tribeEventsTemplate\";s:7:\"default\";s:16:\"tribeEnableViews\";a:1:{i:0;s:4:\"list\";}s:10:\"viewOption\";s:4:\"list\";s:20:\"tribeDisableTribeBar\";b:0;s:16:\"monthEventAmount\";s:1:\"3\";s:23:\"enable_month_view_cache\";b:1;s:18:\"dateWithYearFormat\";s:6:\"F j, Y\";s:21:\"dateWithoutYearFormat\";s:3:\"F j\";s:18:\"monthAndYearFormat\";s:3:\"F Y\";s:17:\"dateTimeSeparator\";s:3:\" @ \";s:18:\"timeRangeSeparator\";s:3:\" - \";s:16:\"datepickerFormat\";s:1:\"0\";s:21:\"tribeEventsBeforeHTML\";s:0:\"\";s:20:\"tribeEventsAfterHTML\";s:0:\"\";}", "yes");
INSERT INTO wp56_options VALUES("210", "widget_tribe-events-list-widget", "a:2:{i:2;a:5:{s:5:\"title\";s:15:\"Upcoming Events\";s:5:\"limit\";s:1:\"5\";s:18:\"no_upcoming_events\";b:0;s:20:\"featured_events_only\";b:0;s:13:\"jsonld_enable\";i:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("211", "tribe_last_save_post", "1534473629", "yes");
INSERT INTO wp56_options VALUES("225", "category_children", "a:0:{}", "yes");
INSERT INTO wp56_options VALUES("286", "wpea_options", "a:5:{s:10:\"eventbrite\";a:1:{s:11:\"oauth_token\";s:0:\"\";}s:6:\"meetup\";a:1:{s:14:\"meetup_api_key\";s:0:\"\";}s:8:\"facebook\";a:2:{s:15:\"facebook_app_id\";s:0:\"\";s:19:\"facebook_app_secret\";s:0:\"\";}s:4:\"ical\";a:0:{}s:4:\"wpea\";a:1:{s:17:\"deactive_wpevents\";s:3:\"yes\";}}", "yes");
INSERT INTO wp56_options VALUES("297", "et_account_status", "active", "no");
INSERT INTO wp56_options VALUES("301", "widget_et-recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("302", "widget_et-recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("303", "widget_et-recent-reviews", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("304", "widget_et-recent-videos", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wp56_options VALUES("347", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO wp56_options VALUES("453", "_site_transient_timeout_browser_b853087b2e0a4e0498daba8d5fabac45", "1534604285", "no");
INSERT INTO wp56_options VALUES("454", "_site_transient_browser_b853087b2e0a4e0498daba8d5fabac45", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"68.0.3440.106\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO wp56_options VALUES("652", "_transient_timeout_plugin_slugs", "1534456858", "no");
INSERT INTO wp56_options VALUES("653", "_transient_plugin_slugs", "a:9:{i:0;s:19:\"akismet/akismet.php\";i:1;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:9:\"hello.php\";i:4;s:19:\"jetpack/jetpack.php\";i:5;s:31:\"sg-cachepress/sg-cachepress.php\";i:6;s:43:\"the-events-calendar/the-events-calendar.php\";i:7;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:8;s:43:\"wp-event-aggregator/wp-event-aggregator.php\";}", "no");
INSERT INTO wp56_options VALUES("664", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.2.40\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO wp56_options VALUES("665", "duplicator_version_plugin", "1.2.40", "yes");
INSERT INTO wp56_options VALUES("670", "duplicator_ui_view_state", "a:3:{s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"1\";}", "yes");
INSERT INTO wp56_options VALUES("680", "_site_transient_timeout_et_core_version", "1534544417", "no");
INSERT INTO wp56_options VALUES("681", "_site_transient_et_core_version", "3.11.1", "no");
INSERT INTO wp56_options VALUES("682", "ai1wm_secret_key", "q8CcDZ4wfjkA", "yes");
INSERT INTO wp56_options VALUES("683", "ai1wm_status", "a:2:{s:4:\"type\";s:8:\"download\";s:7:\"message\";s:222:\"<a href=\"https://murrysvilledeals.com/wp-content/ai1wm-backups/murrysvilledeals.com-20180815-220119-977.wpress\" class=\"ai1wm-button-green ai1wm-emphasize\"><span>Download murrysvilledeals.com</span><em>Size: 117 MB</em></a>\";}", "yes");
INSERT INTO wp56_options VALUES("693", "ai1wm_updater", "a:0:{}", "yes");
INSERT INTO wp56_options VALUES("707", "_site_transient_timeout_theme_roots", "1534437519", "no");
INSERT INTO wp56_options VALUES("708", "_site_transient_theme_roots", "a:5:{s:5:\"Extra\";s:7:\"/themes\";s:52:\"Your-Generated-Divi-child-theme-template-by-DiviCake\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO wp56_options VALUES("709", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1534435719;s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:5:\"4.0.8\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:4:\"6.73\";s:25:\"duplicator/duplicator.php\";s:6:\"1.2.40\";s:9:\"hello.php\";s:3:\"1.7\";s:19:\"jetpack/jetpack.php\";s:5:\"6.3.3\";s:31:\"sg-cachepress/sg-cachepress.php\";s:5:\"4.0.7\";s:43:\"the-events-calendar/the-events-calendar.php\";s:6:\"4.6.21\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:5:\"2.2.4\";s:43:\"wp-event-aggregator/wp-event-aggregator.php\";s:5:\"1.5.4\";}s:8:\"response\";a:1:{s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"6.4.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.4.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:60:\"https://ps.w.org/jetpack/assets/icon-256x256.png?rev=1791404\";s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=1791404\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=1791404\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.8\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:8:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:37:\"w.org/plugins/all-in-one-wp-migration\";s:4:\"slug\";s:23:\"all-in-one-wp-migration\";s:6:\"plugin\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:11:\"new_version\";s:4:\"6.73\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/all-in-one-wp-migration/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.6.73.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=1268186\";s:2:\"1x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=1268186\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=1876524\";s:2:\"1x\";s:78:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=1876524\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.40\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.40.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"sg-cachepress/sg-cachepress.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/sg-cachepress\";s:4:\"slug\";s:13:\"sg-cachepress\";s:6:\"plugin\";s:31:\"sg-cachepress/sg-cachepress.php\";s:11:\"new_version\";s:5:\"4.0.7\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/sg-cachepress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/sg-cachepress.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/sg-cachepress/assets/icon-256x256.png?rev=1587055\";s:2:\"1x\";s:66:\"https://ps.w.org/sg-cachepress/assets/icon-128x128.png?rev=1587055\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/sg-cachepress/assets/banner-772x250.jpg?rev=1587055\";}s:11:\"banners_rtl\";a:0:{}}s:43:\"the-events-calendar/the-events-calendar.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:33:\"w.org/plugins/the-events-calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:43:\"the-events-calendar/the-events-calendar.php\";s:11:\"new_version\";s:6:\"4.6.21\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/the-events-calendar/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.21.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-256x256.png?rev=1679210\";s:2:\"1x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-128x128.png?rev=1679210\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=1907269\";s:2:\"1x\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=1907269\";}s:11:\"banners_rtl\";a:0:{}}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/wp-clone-by-wp-academy\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.2.4\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.2.4.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:73:\"https://s.w.org/plugins/geopattern-icon/wp-clone-by-wp-academy_e6cd21.svg\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/wp-clone-by-wp-academy/assets/banner-772x250.jpg?rev=706555\";}s:11:\"banners_rtl\";a:0:{}}s:43:\"wp-event-aggregator/wp-event-aggregator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:33:\"w.org/plugins/wp-event-aggregator\";s:4:\"slug\";s:19:\"wp-event-aggregator\";s:6:\"plugin\";s:43:\"wp-event-aggregator/wp-event-aggregator.php\";s:11:\"new_version\";s:5:\"1.5.4\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-event-aggregator/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-event-aggregator.1.5.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wp-event-aggregator/assets/icon-256x256.jpg?rev=1665432\";s:2:\"1x\";s:72:\"https://ps.w.org/wp-event-aggregator/assets/icon-128x128.jpg?rev=1665432\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/wp-event-aggregator/assets/banner-1544x500.png?rev=1576440\";s:2:\"1x\";s:74:\"https://ps.w.org/wp-event-aggregator/assets/banner-772x250.png?rev=1576440\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO wp56_options VALUES("713", "_site_transient_timeout_et_core_path", "1534544417", "no");
INSERT INTO wp56_options VALUES("714", "_site_transient_et_core_path", "/home/murrysv3/public_html/wp-content/themes/Extra/core", "no");
INSERT INTO wp56_options VALUES("727", "_transient_timeout_tribe_aggregator_services_list", "1534559890", "no");
INSERT INTO wp56_options VALUES("728", "_transient_tribe_aggregator_services_list", "a:1:{s:6:\"origin\";a:1:{i:0;O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"csv\";s:4:\"name\";s:8:\"CSV File\";}}}", "no");
INSERT INTO wp56_options VALUES("729", "_transient_timeout_feed_c79c3cdea5388a31f6913c1e3a296b1f", "1534516694", "no");
INSERT INTO wp56_options VALUES("730", "_transient_feed_c79c3cdea5388a31f6913c1e3a296b1f", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Xylus Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://xylusthemes.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Premium Wordpress Themes and Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Aug 2018 13:01:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://i2.wp.com/xylusthemes.com/wp-content/uploads/2017/02/xt_logo.png?fit=32{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C32&ssl=1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Xylus Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://xylusthemes.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Showing Facebook Events on WordPress using  Facebook Event Sortcode &amp; Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://xylusthemes.com/showing-facebook-events-on-wordpress-using-facebook-event-sortcode-widget/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://xylusthemes.com/showing-facebook-events-on-wordpress-using-facebook-event-sortcode-widget/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 May 2018 13:01:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"facebook event\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"Wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://xylusthemes.com/?p=16236\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"As you know recently Facebook has restricted API for all so no plugin are able to fetch Event from Facebook. They are launching updated API with new approval process so...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://xylusthemes.com/showing-facebook-events-on-wordpress-using-facebook-event-sortcode-widget/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Import Eventbrite Events Pro 1.5.0 here, what’s new and how to update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://xylusthemes.com/import-eventbrite-events-pro-1-5-0-here-whats-new-and-how-to-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://xylusthemes.com/import-eventbrite-events-pro-1-5-0-here-whats-new-and-how-to-update/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Apr 2018 16:49:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://xylusthemes.com/?p=15486\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:169:\"We have updated Import Eventbrite Events Pro to 1.5.0. it is a major release, we have added some new cool features with some improvements and bug fixes. You can found...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://xylusthemes.com/import-eventbrite-events-pro-1-5-0-here-whats-new-and-how-to-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15486\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Updates: Import Facebook Events Issue due to Facebook API change\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://xylusthemes.com/updates-import-facebook-events-issue-due-to-facebook-api-change/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://xylusthemes.com/updates-import-facebook-events-issue-due-to-facebook-api-change/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Apr 2018 19:00:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://xylusthemes.com/?p=14712\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:356:\"Status: Facebook Events importing working using iCal/.ics file. Date: 04-08-2018- &#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;- &#8211; Now you can import Facebook event into WordPress using our updated plugin which use iCal URL or .ICS...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://xylusthemes.com/updates-import-facebook-events-issue-due-to-facebook-api-change/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14712\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Facebook Event not fetching issue in Import facebook Events &amp; WP Event Aggregator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:156:\"https://xylusthemes.com/error-200-access-to-this-data-is-temporarily-disabled-for-non-active-accounts-due-to-changes-we-are-making-to-the-facebook-platform/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"https://xylusthemes.com/error-200-access-to-this-data-is-temporarily-disabled-for-non-active-accounts-due-to-changes-we-are-making-to-the-facebook-platform/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Mar 2018 09:56:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"WP Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://xylusthemes.com/?p=13982\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"IMPORTANT NOTICE: Facebook has restricted access of Events in API from 4th April due to recent Privacy issue. They have new policy &#38; rules to get Event data, We are...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:161:\"https://xylusthemes.com/error-200-access-to-this-data-is-temporarily-disabled-for-non-active-accounts-due-to-changes-we-are-making-to-the-facebook-platform/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Import Facebook Events Pro 1.5.0 here, what’s new and how to update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://xylusthemes.com/import-facebook-events-pro-1-5-0-whats-new-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://xylusthemes.com/import-facebook-events-pro-1-5-0-whats-new-update/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Feb 2018 16:58:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://xylusthemes.com/?p=12000\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"We have updated Import Facebook Events Pro to 1.5.0. it is a major release, we have added some new cool features with some improvements and bug fixes. You can found...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://xylusthemes.com/import-facebook-events-pro-1-5-0-whats-new-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"12000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"How to Import Facebook Events into WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://xylusthemes.com/how-to-import-facebook-events-into-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://xylusthemes.com/how-to-import-facebook-events-into-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 14:56:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"WP Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"event\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"facebook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:22:\"import facebook events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"Wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://xylusthemes.com/?p=1262\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:190:\"Facebook already has lots of Events published by people You don’t have these events but your target users have already published hundreds of thousands of events on facebook already. But...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lisha Patel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://xylusthemes.com/how-to-import-facebook-events-into-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"How to bulk delete WordPress post, comment, users using WP Bulk Delete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://xylusthemes.com/how-to-bulk-delete-wordpress-post-comment-users-using-wp-bulk-delete/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://xylusthemes.com/how-to-bulk-delete-wordpress-post-comment-users-using-wp-bulk-delete/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Dec 2016 13:03:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"WP Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"delete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"delete comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:13:\"delete images\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:15:\"delete metadata\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:14:\"delete wp post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:16:\"wordpress delete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:14:\"wp bulk delete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:14:\"wp mass delete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://xylusthemes.com/?p=1165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"Deleting posts, pages, users or any other content on a WordPress site could be a time taking task. Deleting this content based on several conditions (like date range or category)...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://xylusthemes.com/how-to-bulk-delete-wordpress-post-comment-users-using-wp-bulk-delete/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"How to Delete all WordPress Comment\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://xylusthemes.com/how-to-delete-all-wordpress-comment/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://xylusthemes.com/how-to-delete-all-wordpress-comment/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Dec 2016 14:20:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"WP Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://xylusthemes.com/?p=1055\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"How to Delete all WordPress Comment If you have the need to delete all your comments from your WordPress site, then there are basically two ways you could go about...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://xylusthemes.com/how-to-delete-all-wordpress-comment/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1055\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Extra Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://xylusthemes.com/extra-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://xylusthemes.com/extra-theme/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jun 2016 17:22:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://xylusthemes.com/?p=571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"Extra Theme is one of the latest theme edition from Elegant Themes. Powered by Divi builder and featuring several new modules and layout system, this is an excellent magazine theme...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://xylusthemes.com/extra-theme/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"10 Best Free WordPress Corporate Business Themes of April 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://xylusthemes.com/10-best-free-wordpress-corporate-business-themes-of-april-2016/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://xylusthemes.com/10-best-free-wordpress-corporate-business-themes-of-april-2016/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Apr 2016 06:40:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:6:\"Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Business Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"Corporate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:15:\"Corporate Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:20:\"Free Business themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:21:\"free wordpress themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:18:\"WordPress Template\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:16:\"WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://xylusthemes.com/?p=598\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:187:\"Every Business need modern website now days. Here we have select few Best WordPress  Free Corporate Business themes which can be used to develop your business website free. These Free...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Karan Gadhavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://xylusthemes.com/10-best-free-wordpress-corporate-business-themes-of-april-2016/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"598\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:29:\"https://xylusthemes.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"104208359\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:12:\"nginx/1.14.0\";s:4:\"date\";s:29:\"Fri, 17 Aug 2018 02:38:14 GMT\";s:12:\"content-type\";s:24:\"text/html; charset=UTF-8\";s:14:\"content-length\";s:4:\"2837\";s:4:\"vary\";s:22:\"Accept-Encoding,Cookie\";s:13:\"last-modified\";s:29:\"Fri, 17 Aug 2018 01:09:33 GMT\";s:13:\"accept-ranges\";s:5:\"bytes\";s:13:\"cache-control\";s:17:\"max-age=0, public\";s:7:\"expires\";s:29:\"Fri, 17 Aug 2018 02:38:14 GMT\";s:15:\"referrer-policy\";s:0:\"\";s:6:\"pragma\";s:6:\"public\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911143210\";}", "no");
INSERT INTO wp56_options VALUES("731", "_transient_timeout_feed_mod_c79c3cdea5388a31f6913c1e3a296b1f", "1534516694", "no");
INSERT INTO wp56_options VALUES("732", "_transient_feed_mod_c79c3cdea5388a31f6913c1e3a296b1f", "1534473494", "no");
INSERT INTO wp56_options VALUES("733", "_transient_timeout_feed_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1534516695", "no");
INSERT INTO wp56_options VALUES("734", "_transient_timeout_feed_mod_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1534516695", "no");
INSERT INTO wp56_options VALUES("735", "_transient_feed_mod_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1534473495", "no");
INSERT INTO wp56_options VALUES("736", "_site_transient_timeout_community-events-8f07fe3874e3b105e21de8d982d28c47", "1534516696", "no");
INSERT INTO wp56_options VALUES("737", "_site_transient_community-events-8f07fe3874e3b105e21de8d982d28c47", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"73.174.243.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:25:\"WordCamp Lehigh Valley PA\";s:3:\"url\";s:38:\"https://2018.lehighvalley.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-08-18 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:22:\"Lehigh Valley, PA, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.6125013999999993075107340700924396514892578125;s:9:\"longitude\";d:-75.371751299999999673673301003873348236083984375;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:43:\"Pre-WordCamp Meet + Greet and Happiness Bar\";s:3:\"url\";s:82:\"https://www.meetup.com/Pittsburgh-WordPress-Developers-Designers/events/253495344/\";s:6:\"meetup\";s:20:\"WordPress Pittsburgh\";s:10:\"meetup_url\";s:65:\"https://www.meetup.com/Pittsburgh-WordPress-Developers-Designers/\";s:4:\"date\";s:19:\"2018-09-11 18:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:19:\"Pittsburgh, PA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.45998399999999861620381125248968601226806640625;s:9:\"longitude\";d:-79.9307859999999976707840687595307826995849609375;}}i:2;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:26:\"WordCamp Pittsburgh PA USA\";s:3:\"url\";s:36:\"https://2018.pittsburgh.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-09-22 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Pittsburgh PA USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.424857000000002926753950305283069610595703125;s:9:\"longitude\";d:-80.189424500000001216903910972177982330322265625;}}i:3;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:18:\"WordCamp Baltimore\";s:3:\"url\";s:35:\"https://2018.baltimore.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-10-06 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Baltimore, MD, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:39.2861003000000010842995834536850452423095703125;s:9:\"longitude\";d:-76.60570830000000341897248290479183197021484375;}}i:4;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:18:\"WordCamp Rochester\";s:3:\"url\";s:35:\"https://2018.rochester.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-10-13 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Rochester, NY USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:43.11591059999999941965143079869449138641357421875;s:9:\"longitude\";d:-77.511752999999998792191036045551300048828125;}}}}", "no");
INSERT INTO wp56_options VALUES("738", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1534516696", "no");
INSERT INTO wp56_options VALUES("739", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Thu, 02 Aug 2018 22:13:06 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-43570\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: July 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/08/the-month-in-wordpress-july-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Aug 2018 09:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July. Release of WordPress 4.9.7 On July 5, WordPress 4.9.7 was released,  fixing one security issue and 17 other bugs across the platform. While this is a minor release, incremental fixes [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6411:\"<p>With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Release of WordPress 4.9.7</h2>\n\n<p>On July 5, <a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 was released</a>,  fixing one security issue and 17 other bugs across the platform.<br /></p>\n\n<p>While this is a minor release, incremental fixes are essential to keep WordPress running smoothly. Everyone is encouraged to update as soon as possible and to make sure that automatic updates are switched on.<br /></p>\n\n<p>Would you like to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The New WordPress Editor</h2>\n\n<p>In the upcoming minor release of WordPress, 4.9.8, a new section in the dashboard will feature Gutenberg, the upcoming content editor for WordPress.<br /></p>\n\n<p>While the official release of Gutenberg <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">is scheduled</a> for the coming months, you can already install it as <a href=\"https://wordpress.org/plugins/gutenberg/\">a plugin</a> to test it out right now. Additionally, <a href=\"https://wordpress.org/gutenberg/\">a brand new demo page</a> is now available — play around with the many features the editor has to offer, without installing it on your own site.<br /></p>\n\n<p>Would you like to help build or test Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Page Design Updates on WordPress.org</h2>\n\n<p>Bit by bit we’re refreshing the design of WordPress.org. The latest pages to get a new treatment have been <a href=\"https://wordpress.org/download/\">the Download page</a> and <a href=\"https://profiles.wordpress.org/matt/\">user profiles</a>.<br /></p>\n\n<p>The Meta and Design teams worked hard to make these new designs a reality, with notable contributions from <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/obenland/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>obenland</a>, <a href=\'https://profiles.wordpress.org/mapk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mapk</a>, and <a href=\'https://profiles.wordpress.org/kjellr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kjellr</a>. The new designs enhance the overall look of the site and provide more relevant information to those searching.<br /></p>\n\n<p>Would you like to get involved in the design refresh? Follow the <a href=\"https://make.wordpress.org/meta/\">Meta</a> and <a href=\"https://make.wordpress.org/design/\">Design</a> team blogs and join the #meta and #design channels in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The First WP-CLI Hack Day</h2>\n\n<p>On Friday July 20, the WP-CLI team <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">held their first hack day</a> — a global event encouraging people to contribute to the official command line tool for WordPress.<br /></p>\n\n<p>Run by <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a>, the event <a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\"> was a great success</a>. Twelve pull requests were  merged and another 13 submitted. It also included a video chat to give all contributors a space to meet each other and connect directly.<br /></p>\n\n<p>Would  you like to get involved in contributing to WP-CLI? Follow <a href=\"https://make.wordpress.org/cli/\">the team blog</a> and join the #cli channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The WordPress Foundation is <a href=\"https://wordpressfoundation.org/2018/call-for-organizers-introduction-to-open-source-workshops-for-2018/\">looking for local community organizers to run introductory open-source workshops</a> in 2018.</li><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> compiled <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">updates for the last quarter</a> from the contribution teams all across the WordPress project.</li><li>In a great move for internationalization, <a href=\"https://en.blog.wordpress.com/2018/03/29/the-wordpress-mobile-apps-now-support-right-to-left-languages/\">the WordPress Mobile Apps now support right-to-left languages</a>.</li><li><a href=\"https://make.wordpress.org/community/2018/07/10/stripe-is-now-available-to-all-wordcamps/\">WordCamp events can now accept payment via Stripe</a> — PayPal remains an alternative option.</li><li>The WP-CLI team will soon <a href=\"https://make.wordpress.org/cli/2018/07/19/details-on-the-upcoming-major-release/\">release v2.0</a> of the official WordPress command line tool.</li><li>The Fields API project in WordPress Core <a href=\"https://wptavern.com/wordpress-core-fields-api-project-is-seeking-new-leadership\">is looking for a new lead</a> to drive it forward.</li><li>In WordPress 4.9.8, <a href=\"https://make.wordpress.org/core/2018/07/27/registering-metadata-in-4-9-8/\">it will  be possible</a> for developers to fully register the meta fields used by their plugins and themes.</li><li>After many years of hard work, <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">v1.0.0 of the WordPress Coding Standards for PHP_CodeSniffer</a> has been released.</li><li>The Mobile team <a href=\"https://make.wordpress.org/mobile/2018/07/31/call-for-testing-wordpress-for-ios-10-6/\">is looking for people to help test</a> v10.6 of WordPress for iOS.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15622:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/rianrietveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rianrietveld</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/afercia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd} and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/valendesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>valendesigns</a> (but usually <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Update on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/news/2018/07/update-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jul 2018 19:23:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Focus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6118\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Tammie Lister\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2261:\"<p>Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. As the work on phase one moves into its final stretch, here is what you can expect.<br /></p>\n\n<h4>In Progress</h4>\n\n<ul>\n	<li>Freeze new features in Gutenberg (the feature list can be found <a href=\"https://github.com/WordPress/gutenberg/issues/4894\">here</a>).</li>\n	<li>Hosts, agencies, teachers invited to opt-in sites they have influence over.</li>\n	<li>WordPress.com has opt-in for wp-admin users. The number of sites and posts will be tracked.</li>\n	<li>Mobile app support for Gutenberg will be across iOS and Android.</li>\n</ul>\n\n<h4>July</h4>\n\n<ul>\n	<li>4.9.x release with an invitation to install either Gutenberg or Classic Editor plugin.</li>\n	<li>WordPress.com will move to opt-out. There will be tracking to see who opts out and why.</li>\n	<li>Triage increases and bug gardening escalates to get blockers in Gutenberg down to zero.</li>\n	<li>Gutenberg phase two, Customization exploration begins by moving beyond the post.</li>\n</ul>\n\n<h4>August and beyond</h4>\n\n<ul>\n	<li>All critical issues within Gutenberg are resolved.</li>\n	<li>There is full integration with Calypso and there is opt-in for users there.</li>\n	<li>A goal will be 100k+ sites having made 250k+ posts using Gutenberg.</li>\n	<li>Core merge of Gutenberg begins the 5.0 release cycle.</li>\n	<li>5.0 moves into beta releases and translations are completed.</li>\n	<li>There will be a mobile version of Gutenberg by the end of the year.</li>\n</ul>\n\n<p>WordPress 5.0 could be as soon as August with hundreds of thousands of sites using Gutenberg before release. Learn more about Gutenberg <a href=\"https://wordpress.org/gutenberg/\">here</a>, take it for a <a href=\"https://testgutenberg.com/\">test drive</a>, <a href=\"https://wordpress.org/plugins/gutenberg/\">install</a> on your site, follow along on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> and give your <a href=\"https://wordpressdotorg.polldaddy.com/s/gutenberg-support\">feedback</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6118\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.7 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6091\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 4.9.7 is now available. This is a security and maintenance release for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately. WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3984:\"<p>WordPress 4.9.7 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n<p>WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads directory.</p>\n\n<p>Thank you to <a href=\"https://hackerone.com/slavco\">Slavco</a> for reporting the original issue and <a href=\"https://www.wordfence.com/\">Matt Barry</a> for reporting related issues.</p>\n\n<p>Seventeen other bugs were fixed in WordPress 4.9.7. Particularly of note were:</p>\n\n<ul>\n	<li>Taxonomy: Improve cache handling for term queries.</li>\n	<li>Posts, Post Types: Clear post password cookie when logging out.</li>\n	<li>Widgets: Allow basic HTML tags in sidebar descriptions on Widgets admin screen.</li>\n	<li>Community Events Dashboard: Always show the nearest WordCamp if one is coming up, even if there are multiple Meetups happening first.</li>\n	<li>Privacy: Make sure default privacy policy content does not cause a fatal error when flushing rewrite rules outside of the admin context.</li>\n</ul>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.7</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n<p>The previously scheduled 4.9.7 is now referred to as 4.9.8, and will follow the <a href=\"https://make.wordpress.org/core/2018/07/04/dev-chat-summary-july-4th-4-9-7-week-7/\">release schedule posted yesterday</a>.</p>\n\n<p>Thank you to everyone who contributed to WordPress 4.9.7:</p>\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/07/the-month-in-wordpress-june-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 09:28:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6087\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June. Another Successful WordCamp Europe On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4627:\"<p>With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Another Successful WordCamp Europe</h2>\n\n<p>On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. Over 2,000 people attended in person, with hundreds more watching live streams of the sessions.</p>\n\n<p>The WordCamp was a great success with plenty of first-time attendees and new WordPress contributors getting involved in the project and community. Recorded sessions from the 65 speakers at the event will be available on WordPress.tv in the coming weeks. In the meantime, check out the <a href=\"https://www.flickr.com/photos/wceu/albums\">photos from the event</a>.</p>\n\n<p><a href=\"https://2018.europe.wordcamp.org/2018/06/16/wordcamp-europe-2019/\">The next WordCamp Europe</a> takes place on June 20-22 2019 in Berlin, Germany. If you’re based in Europe and would like to serve on the organizing team, <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\">fill in the application form</a>.</p>\n\n<h2>Updated Roadmap for the New WordPress Content Editor</h2>\n\n<p>During his keynote session at WordCamp Europe, Matt Mullenweg presented <a href=\"https://gutenbergtimes.com/mullenweg-on-gutenberg-roll-out-plan/\">an updated roadmap</a> for <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new content editor coming in WordPress 5.0.</p>\n\n<p>While the editor is in rapid development, <a href=\"https://make.wordpress.org/core/2018/06/21/whats-new-in-gutenberg-21st-june/\">with v3.1 being released this past month</a>, the team is aiming to ship Gutenberg with WordPress Core in August, 2018. This is not set in stone — the release date may shift as development progresses — but this gives the first realistic idea of when we can expect the editor to be released.</p>\n\n<p>If you would like to contribute to Gutenberg, read <a href=\"https://wordpress.org/gutenberg/handbook/\">the handbook</a>, follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>WordCamp Incubator Cities Announced</h2>\n\n<p>The WordCamp Incubator program helps spread WordPress to underserved communities by providing organizing support for their first WordCamp. The first iteration of this program ran successfully in 2016 and empowered three cities to start their own WordPress communities.</p>\n\n<p>This year, the Community Team is running the Incubator program again. After receiving applications from 104 communities, <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\">they have selected</a> Montevideo, Uruguay and Kota Kinabalu, Malaysia to participate in the program. Both cities will receive direct help from experienced WordCamp organizers to run their first-ever WordCamp as a way to help their WordPress community get started.</p>\n\n<p>To find out more about the Incubator program follow the <a href=\"https://make.wordpress.org/community/\">Community team blog</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>The WordPress community of Spain recently <a href=\"https://twitter.com/wp_es/status/1004681694660603904\">received an award</a> for being the best open-source community in the country.</li>\n	<li>This month, WordPress reached <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">the milestone of powering 31{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd} of websites</a>.</li>\n	<li><a href=\"https://wprig.io/introducing-wprig-wordpress/\">WP Rig</a> is a brand new tool to help WordPress developers build better themes.</li>\n	<li><a href=\"https://richtabor.com/gutenberg-block-unit-test/\">Block Unit Test</a> is a new plugin to help theme developers prepare for Gutenberg.</li>\n	<li>Near the end of the month, Zac Gordon hosted <a href=\"https://javascriptforwp.com/conference/\">an online conference</a> focused on JavaScript development in WordPress &#8211; the session videos will be available on YouTube soon.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6087\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2018/06/the-month-in-wordpress-may-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Jun 2018 09:09:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May. Local Communities Celebrate the 15th Anniversary of WordPress Last Sunday, May [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4537:\"<p>This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Local Communities Celebrate the 15th Anniversary of WordPress</h2>\n\n<p>Last Sunday, May 27, WordPress turned 15 years old. This is a noteworthy occasion for an open-source project like WordPress and one well worth celebrating. To mark the occasion, <a href=\"https://wp15.wordpress.net/\">WordPress communities across the world gathered</a> for parties and meetups in honor of the milestone.</p>\n\n<p>Altogether, there were 224 events globally, with <a href=\"https://wp15.wordpress.net/about/\">a few more of those still scheduled</a> to take place in some communities — attend one in your area if you can.</p>\n\n<p>If your city doesn’t have a WordPress meetup group, this is a great opportunity to start one! Learn how with <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/\">the Meetup Organizer Handbook</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Privacy Tools added to WordPress core</h2>\n\n<p>In light of recent changes to data privacy regulations in the EU, WordPress Core shipped important updates <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">in the v4.9.6 release</a>, giving site owners tools to help them comply with the new General Data Protection Regulation (GDPR). It is worth noting, however, that WordPress cannot ensure you are compliant — this is still a site owner’s responsibility.</p>\n\n<p>The new privacy tools include a number of features focused on providing privacy and personal data management to all site users — asking commenters for explicit consent to store their details in a cookie, providing site owners with an easy way to publish a Privacy Policy, and providing data export and erasure tools to all site users that can be extended by plugins to allow the handling of data that they introduce.</p>\n\n<p>To find out more about these features and the other updates, read the <a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">4.9.6 update guide</a>. You can also get involved in contributing to this part of WordPress Core by jumping into the #core-privacy channel in the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>, and following<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>.</p>\n\n<h2>Updates to the WordPress.org Privacy Policy</h2>\n\n<p>In a similar vein, WordPress.org itself has received <a href=\"https://wordpress.org/about/privacy/\">an updated Privacy Policy</a> to make clear what is being tracked and how your data is handled. Along with that, a <a href=\"https://wordpress.org/about/privacy/cookies/\">Cookie Policy</a> has also been added to explain just what is collected and stored in your browser when using the site.</p>\n\n<p>These policies cover all sites on the WordPress.org network — including WordPress.org, WordPress.net, WordCamp.org, BuddyPress.org, bbPress.org, and other related domains and subdomains. It’s important to note that this does not mean that anything has changed in terms of data storage; rather that these documents clarify what data is stored and how it is handled.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>WordCamp US 2018 has <a href=\"https://2018.us.wordcamp.org/2018/05/29/speak-at-wordcamp-us/\">opened up speaker submissions</a> for the December event.</li>\n	<li><a href=\"https://2018.europe.wordcamp.org/2018/05/15/wceu-live-stream-tickets/\">Live stream tickets are now available for WordCamp Europe</a>, happening on June 14-16.</li>\n	<li>Gutenberg, the new editor for WordPress Core, is getting ever closer to the final stages with <a href=\"https://make.wordpress.org/core/2018/05/18/whats-new-in-gutenberg-18th-may/\">a major update</a> this month.</li>\n	<li>In preparation for Gutenberg, <a href=\"https://core.trac.wordpress.org/changeset/43309\">significant work has been done</a> to improve WordPress Core’s build process.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WordPress.org Privacy Policy Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/05/wordpress-org-privacy-policy-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 May 2018 08:06:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"privacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6047\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:325:\"The WordPress.org privacy policy has been updated, hurray! While we weren&#8217;t able to remove all the long sentences, we hope you find the revisions make it easier to understand: how we collect and use data, how long the data we collect is retained, and how you can request a copy of the data you&#8217;ve shared [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:657:\"<p>The <a href=\"https://wordpress.org/about/privacy/\">WordPress.org privacy policy</a> has been updated, hurray! While we weren&#8217;t able to remove <strong>all</strong> the long sentences, we hope you find the revisions make it easier to understand:</p>\n<ul>\n<li>how we collect and use data,</li>\n<li>how long the data we collect is retained, and</li>\n<li>how you can request a copy of the data you&#8217;ve shared with us.</li>\n</ul>\n<p>There hasn&#8217;t been any change to the data that WordPress.org collects or how that data is used; the privacy policy just provides more detail now. Happy reading, and thanks for using WordPress!</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress 4.9.6 Privacy and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 May 2018 19:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5920\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 4.9.6 is now available. This is a privacy and maintenance release. We encourage you to update your sites to take advantage of the new privacy features. Privacy The European Union&#8217;s General Data Protection Regulation (GDPR) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Allen Snook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13399:\"<p>WordPress 4.9.6 is now available. This is a <strong>privacy and maintenance release</strong>. We encourage you to update your sites to take advantage of the new privacy features.</p>\n\n<figure class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=632&#038;ssl=1\" alt=\"A decorative header featuring the text &quot;GDPR&quot; and a lock inside of a blue shield, on multicolor green background.\" class=\"wp-image-5988\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=300{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=768{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=1024{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C512&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<h2 style=\"text-align:left\">Privacy</h2>\n\n<p>The European Union&#8217;s General Data Protection Regulation (<strong>GDPR</strong>) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, use, and share personal data. It also gives individuals more access and choice when it comes to how their own personal data is collected, used, and shared.<br /></p>\n\n<p>It’s important to understand that while the GDPR is a European regulation, its requirements apply to all sites and online businesses that collect, store, and process personal data about EU residents no matter where the business is located.<br /></p>\n\n<p>You can learn more about the GDPR from the European Commission&#8217;s <a href=\"http://ec.europa.eu/justice/smedataprotect/index_en.htm\">Data Protection page</a>.<br /></p>\n\n<p>We&#8217;re committed to supporting site owners around the world in their work to comply with this important law. As part of that effort, we’ve added a number of new privacy features in this release.</p>\n\n<h2 style=\"text-align:left\">Comments</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=632&#038;ssl=1\" alt=\"A screenshot of a comment form, where the new &quot;Save my name, email, and website in this browser for the next time I comment&quot; checkbox is featured.\" class=\"wp-image-5986\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=300{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C291&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=768{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C744&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=1024{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C992&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Logged-out commenters will be given a choice on whether their name, email address, and website are saved in a cookie on their browser.</p>\n\n<h2 style=\"text-align:left\">Privacy Policy Page</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Privacy Settings page.\" class=\"wp-image-5995\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1898&amp;ssl=1 1898w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=300{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C177&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=768{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C453&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=1024{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C604&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Site owners can now designate a privacy policy page. This page will be shown on your login and registration pages. You should manually add a link to your policy to every page on your website. If you have a footer menu, that’s a great place to include your privacy policy.<br /></p>\n\n<p>In addition, we’ve created a guide that includes insights from WordPress and participating plugins on how they handle personal data. These insights can be copied and pasted into your site&#8217;s privacy policy to help you get started.<br /></p>\n\n<p>If you maintain a plugin that collects data, we recommend including that information in WordPress’ privacy policy guide. <a href=\"https://developer.wordpress.org/plugins/privacy/\">Learn more in our Privacy section of the Plugin Handbook</a>.</p>\n\n<h2 style=\"text-align:left\">Data Handling</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Export Personal Data tools page. Several export requests are listed on the page, to demonstrate how the new feature will work.\" class=\"wp-image-5999\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=2372&amp;ssl=1 2372w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=300{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C221&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=768{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C565&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=1024{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}2C753&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<div class=\"wp-block-columns has-2-columns\">\n		<h3 class=\"layout-column-1\">Data Export</h3>\n	\n		<p class=\"layout-column-1\">Site owners can export a ZIP file containing a user&#8217;s personal data, using data gathered by WordPress and participating plugins.</p>\n	\n		<h3 class=\"layout-column-2\">Data Erasure</h3>\n	\n		<p class=\"layout-column-2\">Site owners can erase a user&#8217;s personal data, including data collected by participating plugins.</p>\n	</div>\n\n<blockquote class=\"wp-block-quote\">\n	<p>Howdy,</p>\n	<p>A request has been made to perform the following action on your account:<br /> </p>\n	<p><strong>Export Personal Data</strong><br /> </p>\n	<p>To confirm this, please click on the following link:<br /><a href=\"#\">http://.wordpress.org/wp-login.php?action=confirmaction&#8230;</a><br /> </p>\n	<p>You can safely ignore and delete this email if you do not want to<br /> take this action.<br /> </p>\n	<p>This email has been sent to <a href=\"#\">you@example.com</a>.<br /> </p>\n	<p>Regards,<br /><em>Your friends at WordPress</em><br /><a href=\"http://wordpress.org\"><em> http://wordpress.org</em></a></p>\n</blockquote>\n\n<p>Site owners have a new email-based method that they can use to confirm personal data requests. This request confirmation tool works for both export and erasure requests, and for both registered users and commenters.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2 style=\"text-align:left\">Maintenance</h2>\n\n<p>95 updates were made in WordPress 4.9.6. In addition to the above, particularly of note were:<br /></p>\n\n<ul>\n	<li>&#8220;Mine&#8221; has been added as a filter in the media library.</li>\n	<li>When viewing a plugin in the admin, it will now tell you the minimum PHP version required.</li>\n	<li>We&#8217;ve added new PHP polyfills for forwards-compatibility and proper variable validation.</li>\n	<li>TinyMCE was updated to the latest version (4.7.11).<br /></li>\n</ul>\n\n<p><a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">This post has more information about all of the issues fixed in 4.9.6 if you&#8217;d like to learn more</a>.</p>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.6</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates will start updating soon.<br /></p>\n\n<p class=\"has-background has-very-light-gray-background-color\">Please note that if you’re currently on WordPress 4.9.3, you should manually update your site immediately.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p>Thank you to everyone who contributed to WordPress 4.9.6:<br /><a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/allendav/\">allendav</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bridgetwillard/\">bridgetwillard</a>, <a href=\"https://profiles.wordpress.org/burlingtonbytes/\">Burlington Bytes</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/claudiu/\">claudiu</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericdaams/\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">herregroen</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jesperher/\">Jesper V Nielsen</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/dejliglama/\">Kåre Mulvad Steffensen</a>, <a href=\"https://profiles.wordpress.org/lakenh/\">Laken Hafner</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a>, <a href=\"https://profiles.wordpress.org/pbarthmaier/\">pbrocks</a>, <a href=\"https://profiles.wordpress.org/postphotos/\">postphotos</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a>, <a href=\"https://profiles.wordpress.org/stephdau/\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/teddytime/\">teddytime</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">thomasplevy</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/voneff/\">voneff</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, and <a href=\"https://profiles.wordpress.org/xkon/\">Xenos (xkon) Konstantinos</a>.<br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5920\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"The Month in WordPress: April 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2018/05/the-month-in-wordpress-april-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 May 2018 08:30:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5891\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"This past month saw a lot of preparation for upcoming events and releases across the WordPress project. Read on to find out more about these plans, and everything else that happened around the community in April. The WordPress 15th Anniversary is Coming On May 27 2018, WordPress will turn 15 years old — this is [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4981:\"<p>This past month saw a lot of preparation for upcoming events and releases across the WordPress project. Read on to find out more about these plans, and everything else that happened around the community in April.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>The WordPress 15th Anniversary is Coming</h2>\n\n<p>On May 27 2018, <a href=\"https://wordpress.org/news/2018/04/celebrate-the-wordpress-15th-anniversary-on-may-27/\">WordPress will turn 15 years old</a> — this is a huge milestone for the project, or, indeed, for any open-source platform. The Community Team has been hard at work helping communities around the world plan local anniversary parties.</p>\n\n<p>Check <a href=\"https://wp15.wordpress.net/\">the central anniversary website</a> to see if there’s already a party being planned near you. These parties are all organized by local communities — if there’s no local community in your area, you can <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/#starting-a-new-meetup-com-group\">start one today</a> and host a party yourself.</p>\n\n<h2>Work has Started on a Gutenberg Migration Guide</h2>\n\n<p>With Gutenberg, the upcoming WordPress content editor, in rapid development, a lot of people have been wondering how they will convert their existing plugins to work with the new features. To mitigate the issues here and help people overcome any migration hurdles, <a href=\"https://make.wordpress.org/core/2018/04/26/your-help-wanted-gutenberg-migration-guide/\">a Gutenberg Migration Guide is underway</a> to assist developers with making their code Gutenberg-compatible.</p>\n\n<p>If you’d like to contribute to this guide, you can review <a href=\"https://github.com/danielbachhuber/gutenberg-migration-guide\">the existing documentation on GitHub</a> and <a href=\"https://github.com/danielbachhuber/gutenberg-migration-guide/issues\">open a new issue</a> if you find something to add.</p>\n\n<h2>Theme Review Team Launches Trusted Authors Program</h2>\n\n<p>Reviews of themes submitted to the Theme Directory can take quite a while to complete. In order to combat this issue and to make the theme submission process smoother for everyone, <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">the Theme Review Team is introducing a Trusted Authors Program</a>.</p>\n\n<p>This program will allow frequent and reliable theme authors to apply for trusted status, allowing them to upload themes more frequently and to have their themes automatically approved. This will allow more high-quality themes to be added to the directory, as well as recognize the hard work that authors put in to build their themes.</p>\n\n<p>If you would like to get involved with reviewing themes, you can read <a href=\"https://make.wordpress.org/themes/handbook/get-involved/become-a-reviewer/\">their getting started guide</a>, follow the <a href=\"https://make.wordpress.org/themes/\">team blog</a> and join the #themereview channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n    <li><a href=\"https://wordpress.org/news/2018/04/wordpress-4-9-5-security-and-maintenance-release/\">WordPress 4.9.5 was released</a> early this month, fixing numerous bugs and potential security issues. The two leads for this release <a href=\"https://make.wordpress.org/core/2018/04/20/4-9-5-feedback-leading-a-wordpress-minor-release/\">published some interesting feedback</a> about the process.</li>\n    <li>In addition to the Trusted Authors Program mentioned above, the Theme Review Team is <a href=\"https://make.wordpress.org/themes/2018/04/09/changes-in-theme-review-process/\">making some changes to their review process</a> to minimize theme review delays.<br /></li>\n    <li>The Marketing Team produced <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">a handy Contributor Day onboarding PDF</a> for organizers to hand out to contributors attending WordCamps.</li>\n    <li>The Accessibility Team is actively looking for contributors for <a href=\"https://make.wordpress.org/accessibility/handbook/\">their handbook</a>.</li>\n    <li>A new type of WordCamp, <a href=\"https://make.wordpress.org/community/2018/04/03/want-to-help-organize-a-wordcamp-for-organizers/\">targeted at organizers</a>, is in the planning stages now.</li>\n    <li><a href=\"https://wordpress.org/about/\">The WordPress.org About pages</a> received a significant redesign to make them more clear and useful.</li>\n    <li>The Community Team <a href=\"https://make.wordpress.org/community/2018/04/27/wordcamp-incubator-program-2018-2019-roadmap/\">posted the roadmap</a> for this year’s WordCamp Incubator program.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5891\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 17 Aug 2018 02:38:16 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 02 Aug 2018 22:13:06 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911143210\";}", "no");
INSERT INTO wp56_options VALUES("740", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1534516696", "no");
INSERT INTO wp56_options VALUES("741", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1534473496", "no");
INSERT INTO wp56_options VALUES("742", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1534516696", "no");
INSERT INTO wp56_options VALUES("743", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1534516696", "no");
INSERT INTO wp56_options VALUES("744", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1534473496", "no");
INSERT INTO wp56_options VALUES("745", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1534516696", "no");
INSERT INTO wp56_options VALUES("746", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\'>WordPress 4.9.8 Maintenance Release</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-for-ios-10-6-adds-a-detailed-site-activity-log\'>WPTavern: WordPress for iOS 10.6 Adds A Detailed Site Activity Log</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-com-boots-sandy-hook-conspiracy-theory-sites-bans-malicious-publication-of-unauthorized-images-of-minors\'>WPTavern: WordPress.com Boots Sandy Hook Conspiracy Theory Sites, Bans Malicious Publication of Unauthorized Images of Minors</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wpweekly-episode-327-truth-misinformation-and-good-ideas\'>WPTavern: WPWeekly Episode 327 – Truth, Misinformation, and Good Ideas</a></li></ul></div>", "no");

DROP TABLE IF EXISTS wp56_postmeta;

CREATE TABLE `wp56_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8;

INSERT INTO wp56_postmeta VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO wp56_postmeta VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO wp56_postmeta VALUES("21", "14", "_et_pb_predefined_default_layout", "on");
INSERT INTO wp56_postmeta VALUES("22", "14", "_et_pb_predefined_default_type", "home");
INSERT INTO wp56_postmeta VALUES("24", "15", "_et_pb_predefined_default_layout", "on");
INSERT INTO wp56_postmeta VALUES("25", "15", "_et_pb_predefined_default_type", "index");
INSERT INTO wp56_postmeta VALUES("26", "15", "_extra_layout_default", "1");
INSERT INTO wp56_postmeta VALUES("29", "17", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("30", "17", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("31", "18", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("32", "18", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("33", "19", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("34", "19", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("35", "20", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("36", "20", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("37", "21", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("38", "21", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("39", "22", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("40", "22", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("41", "23", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("42", "23", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("43", "24", "_et_pb_predefined_layout", "on");
INSERT INTO wp56_postmeta VALUES("44", "24", "_et_pb_built_for_post_type", "layout");
INSERT INTO wp56_postmeta VALUES("45", "25", "_wp_attached_file", "2018/08/Copy-of-Ice-Cream-Party.png");
INSERT INTO wp56_postmeta VALUES("46", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:812;s:6:\"height\";i:223;s:4:\"file\";s:35:\"2018/08/Copy-of-Ice-Cream-Party.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"Copy-of-Ice-Cream-Party-300x82.png\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-768x211.png\";s:5:\"width\";i:768;s:6:\"height\";i:211;s:9:\"mime-type\";s:9:\"image/png\";}s:26:\"et-builder-post-main-image\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-400x223.png\";s:5:\"width\";i:400;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:26:\"et-builder-portfolio-image\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-400x223.png\";s:5:\"width\";i:400;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:33:\"et-builder-gallery-image-portrait\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-400x223.png\";s:5:\"width\";i:400;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"extra-image-medium\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-627x223.png\";s:5:\"width\";i:627;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:17:\"extra-image-small\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-440x223.png\";s:5:\"width\";i:440;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"extra-image-square-medium\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-440x223.png\";s:5:\"width\";i:440;s:6:\"height\";i:223;s:9:\"mime-type\";s:9:\"image/png\";}s:24:\"extra-image-square-small\";a:4:{s:4:\"file\";s:35:\"Copy-of-Ice-Cream-Party-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wp56_postmeta VALUES("47", "1", "_wp_trash_meta_status", "publish");
INSERT INTO wp56_postmeta VALUES("48", "1", "_wp_trash_meta_time", "1533660806");
INSERT INTO wp56_postmeta VALUES("49", "1", "_wp_desired_post_slug", "wordpress-resources-at-siteground");
INSERT INTO wp56_postmeta VALUES("50", "1", "_extra_rating_average", "0");
INSERT INTO wp56_postmeta VALUES("51", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO wp56_postmeta VALUES("52", "30", "_extra_rating_average", "0");
INSERT INTO wp56_postmeta VALUES("53", "30", "_edit_last", "1");
INSERT INTO wp56_postmeta VALUES("54", "30", "_edit_lock", "1533770617:1");
INSERT INTO wp56_postmeta VALUES("60", "30", "_et_pb_use_builder", "on");
INSERT INTO wp56_postmeta VALUES("61", "30", "_et_builder_version", "BB|Divi|3.11.1");
INSERT INTO wp56_postmeta VALUES("63", "30", "_et_pb_ab_stats_refresh_interval", "hourly");
INSERT INTO wp56_postmeta VALUES("64", "30", "_et_pb_old_content", "");
INSERT INTO wp56_postmeta VALUES("65", "30", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO wp56_postmeta VALUES("66", "30", "_et_pb_custom_css", "");
INSERT INTO wp56_postmeta VALUES("67", "30", "_post_review_box_title", "Review");
INSERT INTO wp56_postmeta VALUES("68", "30", "_post_review_box_summary", "");
INSERT INTO wp56_postmeta VALUES("69", "30", "_post_review_box_summary_title", "Summary");
INSERT INTO wp56_postmeta VALUES("70", "30", "_post_review_box_breakdowns_score", "0");
INSERT INTO wp56_postmeta VALUES("71", "30", "_post_review_box_breakdowns_count", "1");
INSERT INTO wp56_postmeta VALUES("72", "30", "_post_review_box_breakdowns", "a:1:{i:0;a:2:{s:5:\"title\";s:0:\"\";s:6:\"rating\";i:0;}}");
INSERT INTO wp56_postmeta VALUES("73", "30", "_extra_sidebar_location", "");
INSERT INTO wp56_postmeta VALUES("74", "30", "_extra_sidebar", "");
INSERT INTO wp56_postmeta VALUES("88", "14", "_edit_lock", "1533770601:1");
INSERT INTO wp56_postmeta VALUES("89", "14", "_edit_last", "1");
INSERT INTO wp56_postmeta VALUES("90", "14", "_et_pb_use_builder", "on");
INSERT INTO wp56_postmeta VALUES("91", "14", "_et_builder_version", "BB|Divi|3.11.1");
INSERT INTO wp56_postmeta VALUES("92", "14", "_et_pb_ab_stats_refresh_interval", "hourly");
INSERT INTO wp56_postmeta VALUES("93", "14", "_et_pb_old_content", "");
INSERT INTO wp56_postmeta VALUES("94", "14", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO wp56_postmeta VALUES("95", "14", "_et_pb_custom_css", "");
INSERT INTO wp56_postmeta VALUES("97", "14", "_extra_sidebar_location", "");
INSERT INTO wp56_postmeta VALUES("98", "14", "_extra_sidebar", "");
INSERT INTO wp56_postmeta VALUES("99", "40", "_wp_attached_file", "2018/08/795-x-500-4.png");
INSERT INTO wp56_postmeta VALUES("100", "40", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:948;s:6:\"height\";i:557;s:4:\"file\";s:23:\"2018/08/795-x-500-4.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-300x176.png\";s:5:\"width\";i:300;s:6:\"height\";i:176;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-768x451.png\";s:5:\"width\";i:768;s:6:\"height\";i:451;s:9:\"mime-type\";s:9:\"image/png\";}s:26:\"et-builder-post-main-image\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:26:\"et-builder-portfolio-image\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";}s:33:\"et-builder-gallery-image-portrait\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"extra-image-medium\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-627x376.png\";s:5:\"width\";i:627;s:6:\"height\";i:376;s:9:\"mime-type\";s:9:\"image/png\";}s:17:\"extra-image-small\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-440x264.png\";s:5:\"width\";i:440;s:6:\"height\";i:264;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"extra-image-square-medium\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-440x440.png\";s:5:\"width\";i:440;s:6:\"height\";i:440;s:9:\"mime-type\";s:9:\"image/png\";}s:24:\"extra-image-square-small\";a:4:{s:4:\"file\";s:23:\"795-x-500-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wp56_postmeta VALUES("101", "30", "_thumbnail_id", "40");
INSERT INTO wp56_postmeta VALUES("104", "41", "_edit_last", "1");
INSERT INTO wp56_postmeta VALUES("105", "41", "_edit_lock", "1533770472:1");
INSERT INTO wp56_postmeta VALUES("106", "42", "_wp_attached_file", "2018/08/coding-background-texture.jpg");
INSERT INTO wp56_postmeta VALUES("107", "42", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:847;s:4:\"file\";s:37:\"2018/08/coding-background-texture.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-300x132.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:132;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-768x339.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:339;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"coding-background-texture-1024x452.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:452;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-builder-post-main-image\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:36:\"et-builder-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:38:\"coding-background-texture-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-builder-portfolio-image\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-builder-portfolio-image-single\";a:4:{s:4:\"file\";s:38:\"coding-background-texture-1080x476.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-builder-gallery-image-portrait\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"extra-image-huge\";a:4:{s:4:\"file\";s:38:\"coding-background-texture-1280x768.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"extra-image-single-post\";a:4:{s:4:\"file\";s:38:\"coding-background-texture-1280x640.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"extra-image-medium\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-627x376.jpg\";s:5:\"width\";i:627;s:6:\"height\";i:376;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"extra-image-small\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-440x264.jpg\";s:5:\"width\";i:440;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"extra-image-square-medium\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-440x440.jpg\";s:5:\"width\";i:440;s:6:\"height\";i:440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"extra-image-square-small\";a:4:{s:4:\"file\";s:37:\"coding-background-texture-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wp56_postmeta VALUES("108", "43", "_wp_attached_file", "2018/08/coding-icon_2.jpg");
INSERT INTO wp56_postmeta VALUES("109", "43", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:25:\"2018/08/coding-icon_2.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wp56_postmeta VALUES("110", "44", "_wp_attached_file", "2018/08/coding-icon_8.jpg");
INSERT INTO wp56_postmeta VALUES("111", "44", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:128;s:6:\"height\";i:128;s:4:\"file\";s:25:\"2018/08/coding-icon_8.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wp56_postmeta VALUES("112", "41", "_wp_page_template", "default");
INSERT INTO wp56_postmeta VALUES("113", "41", "_et_pb_use_builder", "on");
INSERT INTO wp56_postmeta VALUES("114", "41", "_et_builder_version", "VB|Divi|3.11.1");
INSERT INTO wp56_postmeta VALUES("115", "41", "_et_pb_show_page_creation", "off");
INSERT INTO wp56_postmeta VALUES("116", "41", "_et_pb_ab_stats_refresh_interval", "hourly");
INSERT INTO wp56_postmeta VALUES("117", "41", "_et_pb_old_content", "");
INSERT INTO wp56_postmeta VALUES("118", "41", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO wp56_postmeta VALUES("119", "41", "_et_pb_custom_css", "");
INSERT INTO wp56_postmeta VALUES("120", "41", "_extra_sidebar_location", "none");
INSERT INTO wp56_postmeta VALUES("121", "41", "_extra_sidebar", "");
INSERT INTO wp56_postmeta VALUES("122", "41", "_et_pb_built_for_post_type", "page");
INSERT INTO wp56_postmeta VALUES("123", "41", "_et_pb_use_ab_testing", "off");
INSERT INTO wp56_postmeta VALUES("125", "41", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"41\" /]");
INSERT INTO wp56_postmeta VALUES("129", "41", "_et_pb_ab_subjects", "");
INSERT INTO wp56_postmeta VALUES("130", "41", "_thumbnail_id", "");
INSERT INTO wp56_postmeta VALUES("131", "54", "_wp_trash_meta_status", "publish");
INSERT INTO wp56_postmeta VALUES("132", "54", "_wp_trash_meta_time", "1533770500");
INSERT INTO wp56_postmeta VALUES("133", "55", "_extra_rating_average", "0");
INSERT INTO wp56_postmeta VALUES("134", "55", "_edit_last", "1");
INSERT INTO wp56_postmeta VALUES("135", "55", "_edit_lock", "1533770551:1");
INSERT INTO wp56_postmeta VALUES("136", "55", "_thumbnail_id", "40");
INSERT INTO wp56_postmeta VALUES("139", "55", "_et_pb_use_builder", "on");
INSERT INTO wp56_postmeta VALUES("140", "55", "_et_builder_version", "BB|Divi|3.11.1");
INSERT INTO wp56_postmeta VALUES("141", "55", "_et_pb_show_page_creation", "on");
INSERT INTO wp56_postmeta VALUES("142", "55", "_et_pb_ab_stats_refresh_interval", "hourly");
INSERT INTO wp56_postmeta VALUES("143", "55", "_et_pb_old_content", "");
INSERT INTO wp56_postmeta VALUES("144", "55", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO wp56_postmeta VALUES("145", "55", "_et_pb_custom_css", "");
INSERT INTO wp56_postmeta VALUES("146", "55", "_post_review_box_title", "Review");
INSERT INTO wp56_postmeta VALUES("147", "55", "_post_review_box_summary", "");
INSERT INTO wp56_postmeta VALUES("148", "55", "_post_review_box_summary_title", "Summary");
INSERT INTO wp56_postmeta VALUES("149", "55", "_post_review_box_breakdowns_score", "0");
INSERT INTO wp56_postmeta VALUES("150", "55", "_post_review_box_breakdowns_count", "1");
INSERT INTO wp56_postmeta VALUES("151", "55", "_post_review_box_breakdowns", "a:1:{i:0;a:2:{s:5:\"title\";s:0:\"\";s:6:\"rating\";i:0;}}");
INSERT INTO wp56_postmeta VALUES("152", "55", "_extra_sidebar_location", "");
INSERT INTO wp56_postmeta VALUES("153", "55", "_extra_sidebar", "");
INSERT INTO wp56_postmeta VALUES("154", "57", "_extra_rating_average", "0");
INSERT INTO wp56_postmeta VALUES("155", "57", "_edit_last", "1");
INSERT INTO wp56_postmeta VALUES("156", "57", "_edit_lock", "1533772114:1");
INSERT INTO wp56_postmeta VALUES("157", "57", "_thumbnail_id", "40");
INSERT INTO wp56_postmeta VALUES("160", "57", "_et_pb_use_builder", "on");
INSERT INTO wp56_postmeta VALUES("161", "57", "_et_builder_version", "BB|Divi|3.11.1");
INSERT INTO wp56_postmeta VALUES("162", "57", "_et_pb_show_page_creation", "on");
INSERT INTO wp56_postmeta VALUES("163", "57", "_et_pb_ab_stats_refresh_interval", "hourly");
INSERT INTO wp56_postmeta VALUES("164", "57", "_et_pb_old_content", "");
INSERT INTO wp56_postmeta VALUES("165", "57", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO wp56_postmeta VALUES("166", "57", "_et_pb_custom_css", "");
INSERT INTO wp56_postmeta VALUES("167", "57", "_post_review_box_title", "Review");
INSERT INTO wp56_postmeta VALUES("168", "57", "_post_review_box_summary", "");
INSERT INTO wp56_postmeta VALUES("169", "57", "_post_review_box_summary_title", "Summary");
INSERT INTO wp56_postmeta VALUES("170", "57", "_post_review_box_breakdowns_score", "0");
INSERT INTO wp56_postmeta VALUES("171", "57", "_post_review_box_breakdowns_count", "1");
INSERT INTO wp56_postmeta VALUES("172", "57", "_post_review_box_breakdowns", "a:1:{i:0;a:2:{s:5:\"title\";s:0:\"\";s:6:\"rating\";i:0;}}");
INSERT INTO wp56_postmeta VALUES("173", "57", "_extra_sidebar_location", "");
INSERT INTO wp56_postmeta VALUES("174", "57", "_extra_sidebar", "");
INSERT INTO wp56_postmeta VALUES("176", "14", "_extra_layout_home", "1");
INSERT INTO wp56_postmeta VALUES("179", "30", "_extra_featured_post", "1");
INSERT INTO wp56_postmeta VALUES("180", "62", "_menu_item_type", "custom");
INSERT INTO wp56_postmeta VALUES("181", "62", "_menu_item_menu_item_parent", "0");
INSERT INTO wp56_postmeta VALUES("182", "62", "_menu_item_object_id", "62");
INSERT INTO wp56_postmeta VALUES("183", "62", "_menu_item_object", "custom");
INSERT INTO wp56_postmeta VALUES("184", "62", "_menu_item_target", "");
INSERT INTO wp56_postmeta VALUES("185", "62", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wp56_postmeta VALUES("186", "62", "_menu_item_xfn", "");
INSERT INTO wp56_postmeta VALUES("187", "62", "_menu_item_url", "https://murrysvilledeals.com/");
INSERT INTO wp56_postmeta VALUES("189", "63", "_menu_item_type", "post_type");
INSERT INTO wp56_postmeta VALUES("190", "63", "_menu_item_menu_item_parent", "0");
INSERT INTO wp56_postmeta VALUES("191", "63", "_menu_item_object_id", "41");
INSERT INTO wp56_postmeta VALUES("192", "63", "_menu_item_object", "page");
INSERT INTO wp56_postmeta VALUES("193", "63", "_menu_item_target", "");
INSERT INTO wp56_postmeta VALUES("194", "63", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wp56_postmeta VALUES("195", "63", "_menu_item_xfn", "");
INSERT INTO wp56_postmeta VALUES("196", "63", "_menu_item_url", "");
INSERT INTO wp56_postmeta VALUES("198", "64", "_menu_item_type", "custom");
INSERT INTO wp56_postmeta VALUES("199", "64", "_menu_item_menu_item_parent", "0");
INSERT INTO wp56_postmeta VALUES("200", "64", "_menu_item_object_id", "64");
INSERT INTO wp56_postmeta VALUES("201", "64", "_menu_item_object", "custom");
INSERT INTO wp56_postmeta VALUES("202", "64", "_menu_item_target", "");
INSERT INTO wp56_postmeta VALUES("203", "64", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wp56_postmeta VALUES("204", "64", "_menu_item_xfn", "");
INSERT INTO wp56_postmeta VALUES("205", "64", "_menu_item_url", "/events");
INSERT INTO wp56_postmeta VALUES("208", "66", "_extra_rating_average", "0");

DROP TABLE IF EXISTS wp56_posts;

CREATE TABLE `wp56_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

INSERT INTO wp56_posts VALUES("1", "2", "2018-08-07 16:07:46", "2018-08-07 16:07:46", "WordPress is an award-winning web software, used by millions of webmasters worldwide for building their website or blog. SiteGround is proud to host this particular WordPress installation and provide users with multiple resources to facilitate the management of their WP websites:\r\n<h3>Expert <a href=\"http://www.siteground.com/wordpress-hosting.htm\">WordPress Hosting</a></h3>\r\nSiteGround provides superior WordPress hosting focused on speed, security and customer service. We take care of WordPress sites security with unique server-level customizations, WP auto-updates, and daily backups. We make them faster by regularly upgrading our hardware, offering free CDN with Railgun and developing our SuperCacher that speeds sites up to 100 times! And last but not least, we provide real WordPress help 24/7! Learn more about SiteGround WordPress hosting\r\n<h3>Wordpress tutorial and knowledgebase articles</h3>\r\nWordPress is considered an easy to work with software. Yet, if you are a beginner you might need some help, or you might be looking for tweaks that do not come naturally even to more advanced users. SiteGround <a href=\"http://www.siteground.com/tutorials/wordpress/\">WordPress tutorial</a> includes installation and theme change instructions, management of WordPress plugins, manual upgrade and backup creation, and more. If you are looking for a more rare setup or modification, you may visit <a href=\"http://kb.siteground.com\">SiteGround Knowledgebase</a>.\r\n<h3><a href=\"http://www.siteground.com/wordpress-hosting/wordpress-themes.htm\">Free WordPress themes</a></h3>\r\nSiteGround experts not only develop various solutions for WordPress sites, but also create unique designs that you could download for free. SiteGround WordPress themes are easy to customize for the particular use of the webmaster.", "WordPress Resources at SiteGround", "", "trash", "open", "open", "", "wordpress-resources-at-siteground__trashed", "", "", "2018-08-07 16:53:26", "2018-08-07 16:53:26", "", "0", "", "0", "post", "", "0");
INSERT INTO wp56_posts VALUES("14", "2", "2018-08-07 16:33:29", "2018-08-07 16:33:29", "[et_pb_section bb_built=\"1\" admin_label=\"section\"][et_pb_row background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider _builder_version=\"3.11.1\" display_featured_posts_only=\"on\" ignore_displayed_posts=\"off\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" remove_drop_shadow=\"off\" /][et_pb_posts_blog_feed_standard _builder_version=\"3.11.1\" category_id=\"0,1\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"on\" content_length=\"excerpt\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_date=\"on\" show_comments=\"on\" show_rating=\"on\" show_more=\"on\" remove_drop_shadow=\"off\" posts_per_page=\"10\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage", "", "publish", "closed", "closed", "", "homepage", "", "", "2018-08-08 23:25:20", "2018-08-08 23:25:20", "", "0", "https://murrysvilledeals.com/?post_type=layout&#038;p=14", "0", "layout", "", "0");
INSERT INTO wp56_posts VALUES("15", "2", "2018-08-07 16:33:29", "2018-08-07 16:33:29", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" category_id=\"-1\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\" /][et_pb_posts_blog_feed_masonry admin_label=\"Blog Feed Masonry\" category_id=\"-1\" posts_per_page=\"12\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Default Category", "", "publish", "closed", "closed", "", "default-category", "", "", "2018-08-07 16:33:29", "2018-08-07 16:33:29", "", "0", "https://murrysvilledeals.com/?post_type=layout&p=15", "0", "layout", "", "0");
INSERT INTO wp56_posts VALUES("17", "2", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" category_id=\"0\" display_featured_posts_only=\"on\" orderby=\"comment_count\" order=\"desc\" enable_autoplay=\"1\" show_thumbnails=\"1\" show_author=\"1\" show_categories=\"1\" show_comments=\"1\" show_rating=\"1\" show_date=\"1\" /][et_pb_posts_blog_feed_masonry admin_label=\"Blog Feed Masonry\" show_pagination=\"1\" show_author=\"1\" show_categories=\"1\" show_featured_image=\"1\" content_length=\"excerpt\" show_date=\"1\" category_id=\"0\" heading_style=\"category\" orderby=\"date\" order=\"desc\" show_comments=\"1\" show_rating=\"1\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Basic", "", "publish", "closed", "closed", "", "homepage-basic", "", "", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=17", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("18", "2", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\"] [/et_pb_featured_posts_slider][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"1_2\"][et_pb_posts admin_label=\"Posts\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"comment_count\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_posts admin_label=\"Posts\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"rating\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_standard admin_label=\"Blog Feed Standard\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"4\"] [/et_pb_posts_blog_feed_standard][/et_pb_column][/et_pb_row][/et_pb_section]", "Standard Blog Homepage", "", "publish", "closed", "closed", "", "standard-blog-homepage", "", "", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=18", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("19", "2", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\"] [/et_pb_featured_posts_slider][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"comment_count\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"rating\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_masonry admin_label=\"Blog Feed Masonry\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"4\"] [/et_pb_posts_blog_feed_masonry][/et_pb_column][/et_pb_row][/et_pb_section]", "Masonry Blog Homepage", "", "publish", "closed", "closed", "", "masonry-blog-homepage", "", "", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=19", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("20", "2", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" category_id=\"0\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\"] [/et_pb_featured_posts_slider][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"1_2\"][et_pb_posts admin_label=\"Posts\" category_id=\"0\" posts_per_page=\"4\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"comment_count\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_posts admin_label=\"Posts\" category_id=\"0\" posts_per_page=\"4\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_carousel admin_label=\"Posts Carousel\" display_featured_posts_only=\"off\" show_date=\"on\" enable_autoplay=\"off\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" category_id=\"0\" posts_per_page=\"4\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"comment_count\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" category_id=\"0\" posts_per_page=\"4\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"rating\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_posts admin_label=\"Posts\" category_id=\"0\" posts_per_page=\"4\" display_featured_posts_only=\"off\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [/et_pb_posts][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_tabbed_posts admin_label=\"Tabbed Posts\" show_thumbnails=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" remove_drop_shadow=\"off\"] [et_pb_tabbed_posts_tab category_id=\"0\" category_name=\"All\" display_featured_posts_only=\"off\" /][et_pb_tabbed_posts_tab category_id=\"0\" category_name=\"All\" display_featured_posts_only=\"off\" /][et_pb_tabbed_posts_tab category_id=\"0\" category_name=\"All\" display_featured_posts_only=\"off\" /][et_pb_tabbed_posts_tab category_id=\"0\" category_name=\"All\" display_featured_posts_only=\"off\" /] [/et_pb_tabbed_posts][/et_pb_column][/et_pb_row][/et_pb_section]", "Magazine Homepage", "", "publish", "closed", "closed", "", "magazine-homepage", "", "", "2018-08-07 16:33:49", "2018-08-07 16:33:49", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=20", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("21", "2", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_standard admin_label=\"Blog Feed Standard\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"8\"] [/et_pb_posts_blog_feed_standard][/et_pb_column][/et_pb_row][/et_pb_section]", "Standard Blog Category", "", "publish", "closed", "closed", "", "standard-blog-category", "", "", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=21", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("22", "2", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_masonry admin_label=\"Blog Feed Masonry\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"10\"] [/et_pb_posts_blog_feed_masonry][/et_pb_column][/et_pb_row][/et_pb_section]", "Masonry Blog Category", "", "publish", "closed", "closed", "", "masonry-blog-category", "", "", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=22", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("23", "2", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\"] [/et_pb_featured_posts_slider][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_standard admin_label=\"Blog Feed Standard\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"6\"] [/et_pb_posts_blog_feed_standard][/et_pb_column][/et_pb_row][/et_pb_section]", "Standard Blog Category With Featured Posts", "", "publish", "closed", "closed", "", "standard-blog-category-with-featured-posts", "", "", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=23", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("24", "2", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "[et_pb_section admin_label=\"section\"][et_pb_row admin_label=\"row\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider admin_label=\"Featured Posts Slider\" display_featured_posts_only=\"on\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" enable_autoplay=\"off\" orderby=\"date\" order=\"desc\" remove_drop_shadow=\"off\"] [/et_pb_featured_posts_slider][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Row\"][et_pb_column type=\"4_4\"][et_pb_posts_blog_feed_masonry admin_label=\"Blog Feed Masonry\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_more=\"on\" show_date=\"on\" display_featured_posts_only=\"off\" show_comments=\"on\" show_rating=\"on\" content_length=\"excerpt\" heading_style=\"category\" orderby=\"date\" order=\"desc\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_read_more=\"off\" read_more_text_size=\"20\" read_more_border_width=\"2\" read_more_border_radius=\"3\" read_more_letter_spacing=\"0\" read_more_use_icon=\"default\" read_more_icon_placement=\"right\" read_more_on_hover=\"on\" read_more_border_radius_hover=\"3\" read_more_letter_spacing_hover=\"0\" remove_drop_shadow=\"off\" posts_per_page=\"6\"] [/et_pb_posts_blog_feed_masonry][/et_pb_column][/et_pb_row][/et_pb_section]", "Masonry Blog Category With Featured Posts", "", "publish", "closed", "closed", "", "masonry-blog-category-with-featured-posts", "", "", "2018-08-07 16:33:50", "2018-08-07 16:33:50", "", "0", "https://murrysvilledeals.com/?post_type=et_pb_layout&p=24", "0", "et_pb_layout", "", "0");
INSERT INTO wp56_posts VALUES("25", "2", "2018-08-07 16:47:08", "2018-08-07 16:47:08", "", "Copy of Ice Cream Party", "", "inherit", "open", "closed", "", "copy-of-ice-cream-party", "", "", "2018-08-07 16:47:08", "2018-08-07 16:47:08", "", "0", "https://murrysvilledeals.com/wp-content/uploads/2018/08/Copy-of-Ice-Cream-Party.png", "0", "attachment", "image/png", "0");
INSERT INTO wp56_posts VALUES("26", "2", "2018-08-07 16:47:15", "2018-08-07 16:47:15", "", "Your-Generated-Divi-child-theme-template-by-DiviCake", "", "publish", "closed", "closed", "", "your-generated-divi-child-theme-template-by-divicake", "", "", "2018-08-09 00:19:53", "2018-08-09 00:19:53", "", "0", "https://murrysvilledeals.com/?p=26", "0", "custom_css", "", "0");
INSERT INTO wp56_posts VALUES("27", "2", "2018-08-07 16:47:15", "2018-08-07 16:47:15", "", "Your-Generated-Divi-child-theme-template-by-DiviCake", "", "inherit", "closed", "closed", "", "26-revision-v1", "", "", "2018-08-07 16:47:15", "2018-08-07 16:47:15", "", "26", "https://murrysvilledeals.com/?p=27", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("28", "2", "2018-08-07 16:53:26", "2018-08-07 16:53:26", "WordPress is an award-winning web software, used by millions of webmasters worldwide for building their website or blog. SiteGround is proud to host this particular WordPress installation and provide users with multiple resources to facilitate the management of their WP websites:\r\n<h3>Expert <a href=\"http://www.siteground.com/wordpress-hosting.htm\">WordPress Hosting</a></h3>\r\nSiteGround provides superior WordPress hosting focused on speed, security and customer service. We take care of WordPress sites security with unique server-level customizations, WP auto-updates, and daily backups. We make them faster by regularly upgrading our hardware, offering free CDN with Railgun and developing our SuperCacher that speeds sites up to 100 times! And last but not least, we provide real WordPress help 24/7! Learn more about SiteGround WordPress hosting\r\n<h3>Wordpress tutorial and knowledgebase articles</h3>\r\nWordPress is considered an easy to work with software. Yet, if you are a beginner you might need some help, or you might be looking for tweaks that do not come naturally even to more advanced users. SiteGround <a href=\"http://www.siteground.com/tutorials/wordpress/\">WordPress tutorial</a> includes installation and theme change instructions, management of WordPress plugins, manual upgrade and backup creation, and more. If you are looking for a more rare setup or modification, you may visit <a href=\"http://kb.siteground.com\">SiteGround Knowledgebase</a>.\r\n<h3><a href=\"http://www.siteground.com/wordpress-hosting/wordpress-themes.htm\">Free WordPress themes</a></h3>\r\nSiteGround experts not only develop various solutions for WordPress sites, but also create unique designs that you could download for free. SiteGround WordPress themes are easy to customize for the particular use of the webmaster.", "WordPress Resources at SiteGround", "", "inherit", "closed", "closed", "", "1-revision-v1", "", "", "2018-08-07 16:53:26", "2018-08-07 16:53:26", "", "1", "https://murrysvilledeals.com/?p=28", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("30", "2", "2018-08-08 22:48:48", "2018-08-08 22:48:48", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 1", "", "publish", "open", "open", "", "sample-post-1", "", "", "2018-08-08 23:25:57", "2018-08-08 23:25:57", "", "0", "https://murrysvilledeals.com/?p=30", "0", "post", "", "0");
INSERT INTO wp56_posts VALUES("32", "2", "2018-08-08 22:48:48", "2018-08-08 22:48:48", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 1", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2018-08-08 22:48:48", "2018-08-08 22:48:48", "", "30", "https://murrysvilledeals.com/?p=32", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("38", "2", "2018-08-08 22:53:58", "2018-08-08 22:53:58", "[et_pb_section bb_built=\"1\" admin_label=\"section\"][et_pb_row background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider _builder_version=\"3.11.1\" category_id=\"0\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"off\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" remove_drop_shadow=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage", "", "inherit", "closed", "closed", "", "14-autosave-v1", "", "", "2018-08-08 22:53:58", "2018-08-08 22:53:58", "", "14", "https://murrysvilledeals.com/?p=38", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("39", "2", "2018-08-08 22:55:11", "2018-08-08 22:55:11", "[et_pb_section bb_built=\"1\" admin_label=\"section\"][et_pb_row background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider _builder_version=\"3.11.1\" category_id=\"0\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"off\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" remove_drop_shadow=\"off\" /][et_pb_posts_blog_feed_standard _builder_version=\"3.11.1\" category_id=\"0\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"on\" content_length=\"excerpt\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_date=\"on\" show_comments=\"on\" show_rating=\"on\" show_more=\"on\" remove_drop_shadow=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2018-08-08 22:55:11", "2018-08-08 22:55:11", "", "14", "https://murrysvilledeals.com/?p=39", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("40", "2", "2018-08-08 23:02:35", "2018-08-08 23:02:35", "", "948 x 557", "", "inherit", "open", "closed", "", "795-x-500-4", "", "", "2018-08-08 23:02:47", "2018-08-08 23:02:47", "", "30", "https://murrysvilledeals.com/wp-content/uploads/2018/08/795-x-500-4.png", "0", "attachment", "image/png", "0");
INSERT INTO wp56_posts VALUES("41", "2", "2018-08-08 23:14:25", "2018-08-08 23:14:25", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_font=\"||||||||\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#C33131\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.11.1\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\" text_font=\"||||||||\"]<h1>Send us a Message</h1>\r[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" title_font=\"|700||on|||||\" title_text_color=\"#000000\" form_field_font=\"||||||||\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#3f5061\" button_border_width=\"10px\" button_border_color=\"#3f5061\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#C33131\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Info</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section]", "Get In Touch", "", "publish", "closed", "closed", "", "get-in-touch", "", "", "2018-08-08 23:19:50", "2018-08-08 23:19:50", "", "0", "https://murrysvilledeals.com/?page_id=41", "0", "page", "", "0");
INSERT INTO wp56_posts VALUES("42", "2", "2018-08-08 23:08:34", "2018-08-08 23:08:34", "", "coding-background-texture", "", "inherit", "open", "closed", "", "coding-background-texture", "", "", "2018-08-08 23:08:34", "2018-08-08 23:08:34", "", "0", "https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wp56_posts VALUES("43", "2", "2018-08-08 23:08:35", "2018-08-08 23:08:35", "", "coding-icon_2", "", "inherit", "open", "closed", "", "coding-icon_2", "", "", "2018-08-08 23:08:35", "2018-08-08 23:08:35", "", "0", "https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wp56_posts VALUES("44", "2", "2018-08-08 23:08:35", "2018-08-08 23:08:35", "", "coding-icon_8", "", "inherit", "open", "closed", "", "coding-icon_8", "", "", "2018-08-08 23:08:35", "2018-08-08 23:08:35", "", "0", "https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wp56_posts VALUES("45", "2", "2018-08-08 23:08:53", "2018-08-08 23:08:53", "[et_pb_section bb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" locked=\"off\" next_background_color=\"#ffffff\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\r\n<h1>Contact Us</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#d4ccff\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Contact Info\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color=\"#ffffff\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_right_1=\"40px\" padding_bottom_1=\"60px\" padding_left_1=\"40px\" padding_top_2=\"60px\" padding_right_2=\"40px\" padding_bottom_2=\"60px\" padding_left_2=\"40px\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\"][et_pb_column type=\"2_3\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#9271f6\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Send us a Message</h1>\r\n[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.0.82\" form_field_font_size=\"16px\" form_field_text_color=\"rgba(114,114,255,0.61)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.82\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.82\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.47\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.82\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.47\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Info</h1>\r\n[/et_pb_text][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow background_layout=\"dark\" _builder_version=\"3.0.82\" text_orientation=\"left\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" link_shape=\"rounded_rectangle\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" link_shape=\"rounded_rectangle\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" link_shape=\"rounded_rectangle\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" link_shape=\"rounded_rectangle\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" link_shape=\"rounded_rectangle\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" admin_label=\"FAQ\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_padding=\"60px|0px|100px|0px\" prev_background_color=\"#000000\" next_background_color=\"#000000\"][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.3em\" text_orientation=\"center\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Frequently Asked Questions</h1>\r\n[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\" /][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nHimenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" admin_label=\"Subscribe\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_blend=\"overlay\" custom_padding=\"100px|0px|180px|0px\" prev_background_color=\"#ffffff\" next_background_color=\"#f7f8fc\"][et_pb_row custom_margin=\"|||\" padding_top_2=\"60px\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_column type=\"4_4\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\r\n<h1>Contact Us</h1>\r\n[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\" /][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#d4ccff\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_4\"][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_signup mailchimp_list=\"MailChimp|03dac884f0\" name_field=\"on\" use_background_color=\"off\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" button_letter_spacing_hover=\"0\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"50px\" box_shadow_spread_button=\"5px\" box_shadow_color_button=\"rgba(9,225,192,0.3)\" /][/et_pb_column][et_pb_column type=\"1_4\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" admin_label=\"Footer\" background_color=\"#f7f8fc\" _builder_version=\"3.0.82\" custom_padding=\"0px|0px|100px|0px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" saved_tabs=\"all\" prev_background_color=\"#ffffff\"][et_pb_row custom_padding=\"0px|0px|100px|0px\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\"][et_pb_blurb title=\"Free Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"-80px|||\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]\r\n\r\nDuis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_blurb title=\"Premium Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"-80px|||\" custom_margin_tablet=\"0px|||\" custom_margin_last_edited=\"on|phone\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]\r\n\r\nDuis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"2\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"]\r\n<h1>Ready to get started?</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"22px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" animation_style=\"fade\" locked=\"off\"]\r\n\r\nGet in touch, or create an account\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_button button_url=\"#\" button_text=\"Create Account\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" locked=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#7272ff\" button_bg_color=\"#ffffff\" button_border_width=\"10px\" button_border_color=\"#ffffff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(181,181,255,0.38)\" locked=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:08:53", "2018-08-08 23:08:53", "", "41", "https://murrysvilledeals.com/?p=45", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("46", "2", "2018-08-08 23:11:31", "2018-08-08 23:11:31", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\" background_color=\"#3F5061\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#d4ccff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|on|||\" header_text_color=\"#9271f6\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Send us a Message</h1>[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.0.87\" form_field_text_color=\"rgba(114,114,255,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#09e1c0\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Info</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"FAQ\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_padding=\"60px|0px|100px|0px\"][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.3em\" text_orientation=\"center\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Frequently Asked Questions</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Subscribe\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_blend=\"overlay\" custom_padding=\"100px|0px|180px|0px\"][et_pb_row custom_margin=\"|||\" padding_top_2=\"60px\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#d4ccff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_signup mailchimp_list=\"MailChimp|03dac884f0\" name_field=\"on\" _builder_version=\"3.0.87\" use_background_color=\"off\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"50px\" box_shadow_spread_button=\"5px\" box_shadow_color_button=\"rgba(9,225,192,0.3)\"][/et_pb_signup][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Footer\" _builder_version=\"3.0.82\" background_color=\"#f7f8fc\" custom_padding=\"0px|0px|100px|0px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" saved_tabs=\"all\"][et_pb_row custom_padding=\"0px|0px|100px|0px\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Free Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Premium Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_margin_tablet=\"0px|||\" custom_margin_last_edited=\"on|phone\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"2\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.5em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"]<h1>Ready to get started?</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"22px\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" animation_style=\"fade\" locked=\"off\"]<p>Get in touch, or create an account</p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Create Account\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#7272ff\" button_bg_color=\"#ffffff\" button_border_width=\"10px\" button_border_color=\"#ffffff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(181,181,255,0.38)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:11:31", "2018-08-08 23:11:31", "", "41", "https://murrysvilledeals.com/?p=46", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("47", "2", "2018-08-08 23:14:10", "2018-08-08 23:14:10", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\" text_font=\"||||||||\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Send us a Message</h1>[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\" form_field_font=\"||||||||\" title_font=\"|700||on|||||\" title_text_color=\"#000000\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#09e1c0\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Info</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"FAQ\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_padding=\"60px|0px|100px|0px\"][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.3em\" text_orientation=\"center\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Frequently Asked Questions</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Subscribe\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_blend=\"overlay\" custom_padding=\"100px|0px|180px|0px\"][et_pb_row custom_margin=\"|||\" padding_top_2=\"60px\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#d4ccff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_signup mailchimp_list=\"MailChimp|03dac884f0\" name_field=\"on\" _builder_version=\"3.0.87\" use_background_color=\"off\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"50px\" box_shadow_spread_button=\"5px\" box_shadow_color_button=\"rgba(9,225,192,0.3)\"][/et_pb_signup][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Footer\" _builder_version=\"3.0.82\" background_color=\"#f7f8fc\" custom_padding=\"0px|0px|100px|0px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" saved_tabs=\"all\"][et_pb_row custom_padding=\"0px|0px|100px|0px\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Free Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Premium Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_margin_tablet=\"0px|||\" custom_margin_last_edited=\"on|phone\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"2\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.5em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"]<h1>Ready to get started?</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"22px\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" animation_style=\"fade\" locked=\"off\"]<p>Get in touch, or create an account</p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Create Account\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#7272ff\" button_bg_color=\"#ffffff\" button_border_width=\"10px\" button_border_color=\"#ffffff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(181,181,255,0.38)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:14:10", "2018-08-08 23:14:10", "", "41", "https://murrysvilledeals.com/?p=47", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("48", "2", "2018-08-08 23:14:25", "2018-08-08 23:14:25", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\r\n<h1>Contact Us</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\" text_font=\"||||||||\"]\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Send us a Message</h1>\r\n[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\" form_field_font=\"||||||||\" title_font=\"|700||on|||||\" title_text_color=\"#000000\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#09e1c0\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Info</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"FAQ\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_padding=\"60px|0px|100px|0px\"][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.3em\" text_orientation=\"center\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Frequently Asked Questions</h1>\r\n[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nHimenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}220{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_text_color=\"#8585bd\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"200ms\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. Sit Etiam porttitor ligula id massa lorem ipsum dolor sit amet, consectetur amet\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Subscribe\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_blend=\"overlay\" custom_padding=\"100px|0px|180px|0px\"][et_pb_row custom_margin=\"|||\" padding_top_2=\"60px\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\r\n<h1>Contact Us</h1>\r\n[/et_pb_text][et_pb_divider color=\"#09e1c0\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.2\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"center\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#d4ccff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]\r\n\r\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_signup mailchimp_list=\"MailChimp|03dac884f0\" name_field=\"on\" _builder_version=\"3.0.87\" use_background_color=\"off\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_use_icon=\"off\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"50px\" box_shadow_spread_button=\"5px\" box_shadow_color_button=\"rgba(9,225,192,0.3)\"][/et_pb_signup][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Footer\" _builder_version=\"3.0.82\" background_color=\"#f7f8fc\" custom_padding=\"0px|0px|100px|0px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" saved_tabs=\"all\"][et_pb_row custom_padding=\"0px|0px|100px|0px\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Free Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nDuis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Premium Courses\" url=\"#\" image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" custom_margin=\"-80px|||\" custom_margin_tablet=\"0px|||\" custom_margin_last_edited=\"on|phone\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n\r\nDuis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"2\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_font_size=\"36px\" header_line_height=\"1.5em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"]\r\n<h1>Ready to get started?</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#8585bd\" text_font_size=\"22px\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" animation_style=\"fade\" locked=\"off\"]\r\n\r\nGet in touch, or create an account\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Create Account\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#7272ff\" button_bg_color=\"#ffffff\" button_border_width=\"10px\" button_border_color=\"#ffffff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}36{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(181,181,255,0.38)\" custom_margin=\"|||\" animation_style=\"zoom\" animation_intensity_zoom=\"6{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]", "Get In Touch", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:14:25", "2018-08-08 23:14:25", "", "41", "https://murrysvilledeals.com/?p=48", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("49", "2", "2018-08-08 23:16:11", "2018-08-08 23:16:11", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_font=\"||||||||\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Send us a Message</h1>\r[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" title_font=\"|700||on|||||\" title_text_color=\"#000000\" form_field_font=\"||||||||\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#09e1c0\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Info</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section]", "Get In Touch", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:16:11", "2018-08-08 23:16:11", "", "41", "https://murrysvilledeals.com/?p=49", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("50", "2", "2018-08-08 23:16:26", "2018-08-08 23:16:26", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\r\n<h1>Contact Us</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_font=\"||||||||\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Send us a Message</h1>\r\n[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" title_font=\"|700||on|||||\" title_text_color=\"#000000\" form_field_font=\"||||||||\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#09e1c0\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\r\n<h1>Info</h1>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section]", "Get In Touch", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:16:26", "2018-08-08 23:16:26", "", "41", "https://murrysvilledeals.com/?p=50", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("52", "2", "2018-08-08 23:19:40", "2018-08-08 23:19:40", "[et_pb_section fb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]<h1>Contact Us</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_font=\"||||||||\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#C33131\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" admin_label=\"Contact Info\" _builder_version=\"3.11.1\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\" text_font=\"||||||||\"]<h1>Send us a Message</h1>\r[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" title_font=\"|700||on|||||\" title_text_color=\"#000000\" form_field_font=\"||||||||\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#3f5061\" button_border_width=\"10px\" button_border_color=\"#3f5061\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" padding_bottom=\"60px\" padding_left=\"40px\" padding_right=\"40px\" padding_top=\"60px\" background_color=\"#C33131\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]<h1>Info</h1>\r[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"] 267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com [/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section]", "Get In Touch", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2018-08-08 23:19:40", "2018-08-08 23:19:40", "", "41", "https://murrysvilledeals.com/?p=52", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("54", "2", "2018-08-08 23:21:40", "2018-08-08 23:21:40", "{\n    \"et_extra[accent_color]\": {\n        \"value\": \"#c33131\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2018-08-08 23:21:40\"\n    }\n}", "", "", "trash", "closed", "closed", "", "23beeefe-69f9-4275-910f-357486c91f67", "", "", "2018-08-08 23:21:40", "2018-08-08 23:21:40", "", "0", "https://murrysvilledeals.com/23beeefe-69f9-4275-910f-357486c91f67/", "0", "customize_changeset", "", "0");
INSERT INTO wp56_posts VALUES("55", "2", "2018-08-08 23:22:55", "2018-08-08 23:22:55", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 2", "", "publish", "open", "open", "", "sample-post-2", "", "", "2018-08-08 23:22:55", "2018-08-08 23:22:55", "", "0", "https://murrysvilledeals.com/?p=55", "0", "post", "", "0");
INSERT INTO wp56_posts VALUES("56", "2", "2018-08-08 23:22:55", "2018-08-08 23:22:55", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 2", "", "inherit", "closed", "closed", "", "55-revision-v1", "", "", "2018-08-08 23:22:55", "2018-08-08 23:22:55", "", "55", "https://murrysvilledeals.com/55-revision-v1/", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("57", "2", "2018-08-08 23:23:21", "2018-08-08 23:23:21", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 3", "", "publish", "open", "open", "", "sample-post-3", "", "", "2018-08-08 23:23:21", "2018-08-08 23:23:21", "", "0", "https://murrysvilledeals.com/?p=57", "0", "post", "", "0");
INSERT INTO wp56_posts VALUES("58", "2", "2018-08-08 23:23:21", "2018-08-08 23:23:21", "[et_pb_section bb_built=\"1\"][et_pb_row][/et_pb_row][/et_pb_section]", "Sample Post 3", "", "inherit", "closed", "closed", "", "57-revision-v1", "", "", "2018-08-08 23:23:21", "2018-08-08 23:23:21", "", "57", "https://murrysvilledeals.com/57-revision-v1/", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("59", "2", "2018-08-08 23:28:49", "2018-08-08 23:28:49", "[et_pb_section bb_built=\"1\" admin_label=\"Contact hero\" _builder_version=\"3.11.1\" background_color=\"#3F5061\" background_image=\"https://murrysvilledeals.com/wp-content/uploads/2018/08/coding-background-texture.jpg\" background_blend=\"overlay\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"-260px\" box_shadow_color=\"#ffffff\" custom_padding=\"100px|0px|60px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_padding=\"27px|0px|100px|0px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"on|desktop\" header_line_height=\"1.3em\" text_orientation=\"center\" background_layout=\"dark\" max_width=\"530px\" module_alignment=\"center\" custom_padding=\"|||\" locked=\"off\"]\n\n<h1>Contact Us</h1>\n\n[/et_pb_text][et_pb_text _builder_version=\"3.11.1\" text_font=\"||||||||\" text_text_color=\"#ffffff\" text_font_size=\"16px\" text_line_height=\"1.9em\" text_orientation=\"center\" max_width=\"540px\" module_alignment=\"center\" locked=\"off\"]\n\nClass aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.\n\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row admin_label=\"Contact Info\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" background_color_2=\"#09e1c0\" padding_top_1=\"60px\" padding_top_2=\"60px\" padding_right_1=\"40px\" padding_right_2=\"40px\" padding_bottom_1=\"60px\" padding_bottom_2=\"60px\" padding_left_1=\"40px\" padding_left_2=\"40px\" _builder_version=\"3.0.82\" background_color=\"#ffffff\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" animation_style=\"zoom\" animation_intensity_zoom=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" animation_starting_opacity=\"100{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\"][et_pb_column type=\"2_3\"][et_pb_text _builder_version=\"3.11.1\" header_font=\"|700|||||||\" header_text_color=\"#000000\" header_font_size=\"36px\" header_line_height=\"1.3em\" custom_margin=\"||40px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\" text_font=\"||||||||\"]\n\n<h1>Send us a Message</h1>\n\n[/et_pb_text][et_pb_contact_form captcha=\"off\" submit_button_text=\"Send Message\" form_background_color=\"rgba(0,0,0,0)\" module_id=\"et_pb_contact_form_0\" _builder_version=\"3.11.1\" title_font=\"|700||on|||||\" title_text_color=\"#000000\" form_field_font=\"||||||||\" form_field_text_color=\"rgba(0,0,0,0.61)\" form_field_font_size=\"16px\" border_width_all=\"1px\" border_color_all=\"rgba(71,74,182,0.12)\" border_style_all=\"solid\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|700||on|||||\" button_use_icon=\"off\" button_letter_spacing_hover=\"2px\" box_shadow_style_button=\"preset1\" box_shadow_vertical_button=\"10px\" box_shadow_blur_button=\"30px\" box_shadow_color_button=\"rgba(146,113,246,0.3)\" use_border_color=\"on\" border_color=\"rgba(71,74,182,0.12)\"][et_pb_contact_field field_id=\"First\" field_title=\"First Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Last\" field_title=\"Last Name\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Phone\" field_title=\"Phone Number\" field_type=\"email\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"3.0.87\" border_radii=\"on||||\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.3em\" background_layout=\"dark\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10{ea5a0def7073f9a9470b2b3b47bdfbc2320131dc84666cd724f99721f7a2b7cd}\" locked=\"off\"]\n\n<h1>Info</h1>\n\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_line_height=\"3em\" background_layout=\"dark\" custom_margin=\"||40px|\"]\n\n267 Banbury Road Summertown, Oxford. 42 Upper Berkeley Street, London. +44 777888 989 hello@massimpressions.com\n\n[/et_pb_text][et_pb_social_media_follow _builder_version=\"3.0.87\" text_orientation=\"left\" background_layout=\"dark\" custom_margin=\"|||\"][et_pb_social_media_follow_network social_network=\"facebook\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]facebook[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]twitter[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"google-plus\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]google-plus[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"instagram\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" follow_button=\"off\" url_new_window=\"on\"]instagram[/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"linkedin\" _builder_version=\"3.0.82\" custom_margin=\"|6px||\" custom_padding=\"|||\" follow_button=\"off\" url_new_window=\"on\"]linkedin[/et_pb_social_media_follow_network][/et_pb_social_media_follow][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "closed", "closed", "", "41-autosave-v1", "", "", "2018-08-08 23:28:49", "2018-08-08 23:28:49", "", "41", "https://murrysvilledeals.com/41-autosave-v1/", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("60", "2", "2018-08-08 23:24:04", "2018-08-08 23:24:04", "[et_pb_section bb_built=\"1\" admin_label=\"section\"][et_pb_row background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider _builder_version=\"3.11.1\" category_id=\"0\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"off\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" remove_drop_shadow=\"off\" /][et_pb_posts_blog_feed_standard _builder_version=\"3.11.1\" category_id=\"0,1\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"on\" content_length=\"excerpt\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_date=\"on\" show_comments=\"on\" show_rating=\"on\" show_more=\"on\" remove_drop_shadow=\"off\" posts_per_page=\"10\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2018-08-08 23:24:04", "2018-08-08 23:24:04", "", "14", "https://murrysvilledeals.com/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("61", "2", "2018-08-08 23:25:20", "2018-08-08 23:25:20", "[et_pb_section bb_built=\"1\" admin_label=\"section\"][et_pb_row background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"4_4\"][et_pb_featured_posts_slider _builder_version=\"3.11.1\" display_featured_posts_only=\"on\" ignore_displayed_posts=\"off\" show_author=\"on\" show_categories=\"on\" show_comments=\"on\" show_rating=\"on\" show_date=\"on\" remove_drop_shadow=\"off\" /][et_pb_posts_blog_feed_standard _builder_version=\"3.11.1\" category_id=\"0,1\" display_featured_posts_only=\"off\" ignore_displayed_posts=\"on\" content_length=\"excerpt\" show_pagination=\"on\" show_author=\"on\" show_categories=\"on\" show_featured_image=\"on\" show_date=\"on\" show_comments=\"on\" show_rating=\"on\" show_more=\"on\" remove_drop_shadow=\"off\" posts_per_page=\"10\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2018-08-08 23:25:20", "2018-08-08 23:25:20", "", "14", "https://murrysvilledeals.com/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO wp56_posts VALUES("62", "2", "2018-08-08 23:50:38", "2018-08-08 23:50:38", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2018-08-11 14:58:32", "2018-08-11 14:58:32", "", "0", "https://murrysvilledeals.com/?p=62", "1", "nav_menu_item", "", "0");
INSERT INTO wp56_posts VALUES("63", "2", "2018-08-08 23:50:38", "2018-08-08 23:50:38", " ", "", "", "publish", "closed", "closed", "", "63", "", "", "2018-08-11 14:58:32", "2018-08-11 14:58:32", "", "0", "https://murrysvilledeals.com/?p=63", "2", "nav_menu_item", "", "0");
INSERT INTO wp56_posts VALUES("64", "2", "2018-08-08 23:50:38", "2018-08-08 23:50:38", "", "Upcoming Events", "", "publish", "closed", "closed", "", "upcoming-events", "", "", "2018-08-11 14:58:33", "2018-08-11 14:58:33", "", "0", "https://murrysvilledeals.com/?p=64", "3", "nav_menu_item", "", "0");
INSERT INTO wp56_posts VALUES("66", "2", "2018-08-17 02:38:15", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2018-08-17 02:38:15", "0000-00-00 00:00:00", "", "0", "https://murrysvilledeals.com/?p=66", "0", "post", "", "0");

DROP TABLE IF EXISTS wp56_term_relationships;

CREATE TABLE `wp56_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO wp56_term_relationships VALUES("1", "1", "0");
INSERT INTO wp56_term_relationships VALUES("30", "1", "0");
INSERT INTO wp56_term_relationships VALUES("55", "1", "0");
INSERT INTO wp56_term_relationships VALUES("57", "1", "0");
INSERT INTO wp56_term_relationships VALUES("62", "3", "0");
INSERT INTO wp56_term_relationships VALUES("63", "3", "0");
INSERT INTO wp56_term_relationships VALUES("64", "3", "0");

DROP TABLE IF EXISTS wp56_term_taxonomy;

CREATE TABLE `wp56_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO wp56_term_taxonomy VALUES("1", "1", "category", "", "0", "3");
INSERT INTO wp56_term_taxonomy VALUES("2", "2", "layout_type", "", "0", "0");
INSERT INTO wp56_term_taxonomy VALUES("3", "3", "nav_menu", "", "0", "3");

DROP TABLE IF EXISTS wp56_termmeta;

CREATE TABLE `wp56_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS wp56_terms;

CREATE TABLE `wp56_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO wp56_terms VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO wp56_terms VALUES("2", "layout", "layout", "0");
INSERT INTO wp56_terms VALUES("3", "Main Menu", "main-menu", "0");

DROP TABLE IF EXISTS wp56_usermeta;

CREATE TABLE `wp56_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

INSERT INTO wp56_usermeta VALUES("24", "2", "nickname", "admin");
INSERT INTO wp56_usermeta VALUES("25", "2", "first_name", "");
INSERT INTO wp56_usermeta VALUES("26", "2", "last_name", "");
INSERT INTO wp56_usermeta VALUES("27", "2", "description", "");
INSERT INTO wp56_usermeta VALUES("28", "2", "rich_editing", "true");
INSERT INTO wp56_usermeta VALUES("29", "2", "syntax_highlighting", "true");
INSERT INTO wp56_usermeta VALUES("30", "2", "comment_shortcuts", "false");
INSERT INTO wp56_usermeta VALUES("31", "2", "admin_color", "fresh");
INSERT INTO wp56_usermeta VALUES("32", "2", "use_ssl", "0");
INSERT INTO wp56_usermeta VALUES("33", "2", "show_admin_bar_front", "true");
INSERT INTO wp56_usermeta VALUES("34", "2", "locale", "");
INSERT INTO wp56_usermeta VALUES("35", "2", "wp56_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO wp56_usermeta VALUES("36", "2", "wp56_user_level", "10");
INSERT INTO wp56_usermeta VALUES("37", "2", "dismissed_wp_pointers", "wp496_privacy");
INSERT INTO wp56_usermeta VALUES("39", "2", "facebook", "");
INSERT INTO wp56_usermeta VALUES("40", "2", "twitter", "");
INSERT INTO wp56_usermeta VALUES("41", "2", "googleplus", "");
INSERT INTO wp56_usermeta VALUES("42", "2", "pinterest", "");
INSERT INTO wp56_usermeta VALUES("43", "2", "tumblr", "");
INSERT INTO wp56_usermeta VALUES("44", "2", "stumbleupon", "");
INSERT INTO wp56_usermeta VALUES("45", "2", "wordpress", "");
INSERT INTO wp56_usermeta VALUES("46", "2", "instagram", "");
INSERT INTO wp56_usermeta VALUES("47", "2", "dribbble", "");
INSERT INTO wp56_usermeta VALUES("48", "2", "vimeo", "");
INSERT INTO wp56_usermeta VALUES("49", "2", "linkedin", "");
INSERT INTO wp56_usermeta VALUES("50", "2", "rss", "");
INSERT INTO wp56_usermeta VALUES("51", "2", "deviantart", "");
INSERT INTO wp56_usermeta VALUES("52", "2", "myspace", "");
INSERT INTO wp56_usermeta VALUES("53", "2", "skype", "");
INSERT INTO wp56_usermeta VALUES("54", "2", "youtube", "");
INSERT INTO wp56_usermeta VALUES("55", "2", "picassa", "");
INSERT INTO wp56_usermeta VALUES("56", "2", "flickr", "");
INSERT INTO wp56_usermeta VALUES("57", "2", "blogger", "");
INSERT INTO wp56_usermeta VALUES("58", "2", "spotify", "");
INSERT INTO wp56_usermeta VALUES("59", "2", "delicious", "");
INSERT INTO wp56_usermeta VALUES("60", "2", "session_tokens", "a:1:{s:64:\"20adc073ee468027cdd34c1372a9ac2bbd246581ea08132de09f2371ec05c6cf\";a:4:{s:10:\"expiration\";i:1534541031;s:2:\"ip\";s:14:\"73.174.243.212\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36\";s:5:\"login\";i:1534368231;}}");
INSERT INTO wp56_usermeta VALUES("61", "2", "wp56_dashboard_quick_press_last_post_id", "66");
INSERT INTO wp56_usermeta VALUES("62", "2", "community-events-location", "a:1:{s:2:\"ip\";s:12:\"73.174.243.0\";}");
INSERT INTO wp56_usermeta VALUES("63", "2", "nav_menu_recently_edited", "3");
INSERT INTO wp56_usermeta VALUES("64", "2", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO wp56_usermeta VALUES("65", "2", "metaboxhidden_nav-menus", "a:5:{i:0;s:21:\"add-post-type-project\";i:1;s:26:\"add-post-type-tribe_events\";i:2;s:12:\"add-post_tag\";i:3;s:20:\"add-project_category\";i:4;s:15:\"add-project_tag\";}");
INSERT INTO wp56_usermeta VALUES("66", "2", "tribe_setDefaultNavMenuBoxes", "1");

DROP TABLE IF EXISTS wp56_users;

CREATE TABLE `wp56_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO wp56_users VALUES("2", "admin", "$P$BCu3Kl08vE2qjtNWluwAGrxZ4aRrof.", "admin", "david@vouchr.io", "", "2018-08-08 23:57:09", "1533772629:$P$BAiInYI2hldrvcqqIrRyJTvYo/Z.qz1", "0", "admin");

