<?php 
$column_class = get_post_meta( get_the_ID(), '_wi_column_layout', true );
if ( ! $column_class ) {
    $column_class = get_theme_mod('wi_disable_blog_2_columns') ? 'single-column' : 'two-column';
}
$column_class = ( $column_class == 'single-column' ) ? 'disable-2-columns' : 'enable-2-columns';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( array( 'wi-post', $column_class ) ); ?> itemscope itemtype="http://schema.org/CreativeWork">
        
    <section class="post-body">
        
        <header class="post-header">
            
            <h2 class="post-title" itemprop="headline">
                <a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a>
            </h2>
            
            <div class="post-header-meta">

                <?php if (!get_theme_mod('wi_disable_blog_date')):?>
                <?php wi_entry_date(); ?>
                <?php endif; ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_categories') ):?>
                <?php wi_entry_categories(); ?>
                <?php endif; ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_author')):?>
                <?php wi_entry_author(); ?>
                <?php endif; ?>
                
                <?php if ( get_theme_mod('wi_blog_view_count')):?>
                <?php wi_view_count(); ?>
                <?php endif; ?>
                
            </div><!-- .post-header-meta -->

        </header><!-- .post-header -->
        
        <?php if ( !get_theme_mod('wi_disable_blog_image') ) wi_entry_thumbnail(); ?>

        <div class="post-content" itemprop="text">
            
            <?php if (get_theme_mod('wi_blog_standard_display') == 'excerpt'): ?>
            
            <div class="entry-content entry-excerpt dropcap-content">
                <?php the_excerpt(); ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_readmore')):?>
                <p class="p-readmore">
                    <a href="<?php the_permalink();?>" class="more-link"><span class="post-more"><?php _e('Keep Reading','wi');?></span></a>
                </p>
                <?php endif; ?>
                
            </div><!-- .entry-content -->
            
            <?php else: ?>
            
            <div class="entry-content dropcap-content">
                <?php
                    the_content('<span class="post-more">' . __('Keep Reading','wi') . '</span>');
                ?>
                <div class="clearfix"></div>
            </div><!-- .entry-content -->
            
            <?php endif; ?>
                
            <?php if (!get_theme_mod('wi_disable_blog_share')):?>
                <?php wi_share(true); ?>
            <?php endif; ?>
                        
            <div class="clearfix"></div>

        </div><!-- .post-content -->
        
        <?php /*------------------------		RELATED		------------------------------- */ ?>
        <?php if( !get_theme_mod('wi_disable_blog_related')): ?>

            <?php

            global $post;
            $current_ID = $post->ID;
            $tags = wp_get_post_tags( $current_ID, array( 'fields' => 'ids' ) );
            $args = array (
                'post_type' => 'post',
                'posts_per_page' => 3,

                'ignore_sticky_posts'   =>  true,
                'no_found_rows' => true,
                'cache_results' => false,
                'post__not_in' => array( $current_ID ),
            );

            if ( ! empty( $tags ) ) {
                
                $args[ 'tag__in' ] = $tags;
                
                $related_query = new WP_Query( $args );
                if ( $related_query->have_posts() ): ?>
                <div class="related-area">

                    <h3 class="blog-related-heading"><span><?php _e('You might be interested in','wi');?></span></h3>

                    <div class="blog-related">
                        <?php while ( $related_query->have_posts() ) : $related_query->the_post(); ?>

                            <?php get_template_part( 'loop/content', 'related' ); ?>

                        <?php endwhile; ?>

                        <div class="clearfix"></div>

                        <div class="line line1"></div>
                        <div class="line line2"></div>

                    </div><!-- .blog-related -->
                    
                </div><!-- #related-posts -->

                <?php	
                endif; // if realted posts
                wp_reset_query();
            }
            ?>

        <?php endif; // blog related ?>
        
    </section><!-- .post-body -->
    
    <div class="clearfix"></div>
    
</article><!-- .wi-post -->