<article id="post-<?php the_ID(); ?>" <?php post_class('post-newspaper'); ?> itemscope itemtype="http://schema.org/CreativeWork">
    
    <section class="post-body">
        
        <?php if ( !get_theme_mod('wi_disable_blog_image') ) wi_entry_thumbnail(); ?>
    
        <header class="newspaper-header">
            
            <h2 class="newspaper-title" itemprop="headline">
                
                <a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a>
            
            </h2>
            
            <div class="newspaper-meta">

                <?php if (!get_theme_mod('wi_disable_blog_date')):?>
                <?php wi_entry_date(); ?>
                <?php endif; ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_categories') ):?>
                <?php wi_entry_categories(); ?>
                <?php endif; ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_author')):?>
                <?php wi_entry_author(); ?>
                <?php endif; ?>
                
                <?php if ( get_theme_mod('wi_blog_view_count')):?>
                <?php wi_view_count(); ?>
                <?php endif; ?>
                
            </div><!-- .newspaper-meta -->

        </header><!-- .newspaper-header -->
        
        <div class="post-content" itemprop="text">
            
            <?php if (get_theme_mod('wi_blog_standard_display') == 'excerpt'): ?>
            
            <div class="newspaper-content newspaper-excerpt">
                <?php the_excerpt(); ?>
                
                <?php if (!get_theme_mod('wi_disable_blog_readmore')):?>
                <p class="p-readmore">
                    <a href="<?php the_permalink();?>" class="more-link"><span class="post-more"><?php _e('Keep Reading','wi');?></span></a>
                </p>
                <?php endif; ?>
                
            </div><!-- .entry-content -->
            
            <?php else: ?>
            
            <div class="newspaper-content dropcap-content small-dropcap-content">
                
                <?php the_content('<span class="post-more">' . __('Keep Reading','wi') . '</span>');?>
                
            </div><!-- .newspaper-content -->
            
            <?php endif; // display ?>

            <div class="clearfix"></div>
            
            <?php if (!get_theme_mod('wi_disable_blog_share')):?>
                <?php wi_share(true); ?>
            <?php endif; ?>
            
            <div class="clearfix"></div>
            
            <?php /*------------------------		RELATED		------------------------------- */ ?>
        <?php if( !get_theme_mod('wi_disable_blog_related')): ?>

            <?php
            global $post;
            $current_ID = $post->ID;
            $tags = wp_get_post_tags( $current_ID, array( 'fields' => 'ids' ) );
            $args = array (
                'post_type' => 'post',
                'posts_per_page' => 3,

                'ignore_sticky_posts'   =>  true,
                'no_found_rows' => true,
                'cache_results' => false,
                'post__not_in' => array( $current_ID ),
            );

            if ( ! empty( $tags ) ) {
                
                $args[ 'tag__in' ] = $tags;
                $related_posts = get_posts( $args );
                if ( $related_posts ): $count = 0;?>
                <div class="related-area">

                    <h3 class="newspaper-related-heading"><span><?php _e('You might be interested in','wi');?></span></h3>

                    <div class="newspaper-related">
                        <?php foreach ( $related_posts as $post ): setup_postdata($post); $count++;?>

                            <?php get_template_part('loop/content', 'related-newspaper' ); ?>

                        <?php endforeach; ?>

                        <?php wp_reset_postdata(); ?>

                        <div class="clearfix"></div>

                    </div><!-- .blog-related -->
                </div><!-- #related-posts -->

                <?php	
                endif; // if realted posts
            }
            ?>

        <?php endif; // blog related ?>

        </div><!-- .post-content -->
        
    </section><!-- .post-body -->
    
    <div class="clearfix"></div>
    
</article><!-- .post-newspaper -->
