<article id="post-<?php the_ID(); ?>" <?php post_class('post-grid'); ?> itemscope itemtype="http://schema.org/CreativeWork">
    
    <div class="grid-inner">
    
        <?php wi_display_thumbnail('thumbnail-medium','grid-thumbnail',true,true, true); ?>

        <section class="grid-body">

            <div class="post-content">

                <header class="grid-header">

                    <div class="grid-meta">

                        <?php if (!get_theme_mod('wi_disable_blog_date')):?>
                        <?php wi_short_date(); ?>
                        <?php endif; ?>

                        <?php if (!get_theme_mod('wi_disable_blog_categories')):?>
                        <?php wi_entry_categories(); ?>
                        <?php endif; ?>

                    </div><!-- .grid-meta -->

                    <h2 class="grid-title" itemprop="headline">

                        <a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a>

                    </h2>

                </header><!-- .grid-header -->

                <?php $grid_excerpt_length = get_theme_mod('wi_grid_excerpt_length') ? absint(get_theme_mod('wi_grid_excerpt_length')) : 22; 
                if ($grid_excerpt_length < 1) $grid_excerpt_length = 22;
                ?>
                <div class="grid-content" itemprop="text">
                    <p> 
                        <?php echo wi_subword(get_the_excerpt(),0,$grid_excerpt_length); ?> &hellip;

                        <?php if (!get_theme_mod('wi_disable_blog_readmore')):?>
                        <a href="<?php the_permalink();?>" class="readmore"><?php _e('Keep Reading','wi');?></a>
                        <?php endif; ?>
                    </p>
                </div><!-- .grid-content -->

                <div class="clearfix"></div>

            </div><!-- .post-content -->

        </section><!-- .grid-body -->

        <div class="clearfix"></div>
    
    </div><!-- .grid-inner -->

</article><!-- .post-grid -->