<?php
/**
 * Font List
 *
 * Normal fonts like Helvetica Neu, Times...
 *
 * Google fonts list. This list will be updated constantly
 *
 * Please DO NOT change this function in your child theme
 *
 * If you need to append more fonts, please use the filter provided
 *
 * @pacekage Fox
 * @since Fox 1.0
 */

if ( !function_exists( 'fox_normal_fonts' ) ) :
/**
 * Normal fonts
 *
 * @return array of normal fonts
 */
function fox_normal_fonts() {

    $fonts = array(
        'Helvetica' => array( 'face' => 'Helvetica Neue', 'category' => 'sans-serif' ),
        'Arial' => array( 'face' => 'Arial', 'category' => 'sans-serif' ),
        'Times' => array( 'face' => 'Times', 'category' => 'serif' ),
        'Georgia' => array( 'face' => 'Georgia', 'category' => 'serif' ),
    );
    
    return apply_filters( 'fox_normal_fonts', $fonts );

}

endif;

if ( !function_exists( 'fox_google_fonts' ) ) :
/**
 * Google fonts
 *
 * @return array of google fonts
 *
 * @updated 08/12/2016
 */
function fox_google_fonts() {

    $fonts = array('ABeeZee' => array( 'category' => 'sans-serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Abel' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Abhaya Libre' => array( 'category' => 'serif','styles'=>array('regular','500','600','700','800'),'subsets'=>array('latin','latin-ext','sinhala') ),'Abril Fatface' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Aclonica' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Acme' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Actor' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Adamina' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Advent Pro' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700'),'subsets'=>array('latin','latin-ext','greek') ),'Aguafina Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Akronim' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Aladin' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Aldrich' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Alef' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','hebrew') ),'Alegreya' => array( 'category' => 'serif','styles'=>array('regular','italic','500','500italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Alegreya SC' => array( 'category' => 'serif','styles'=>array('regular','italic','500','500italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Alegreya Sans' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','300','300italic','regular','italic','500','500italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Alegreya Sans SC' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','300','300italic','regular','italic','500','500italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Alex Brush' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Alfa Slab One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Alice' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','cyrillic') ),'Alike' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Alike Angular' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Allan' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Allerta' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Allerta Stencil' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Allura' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Almendra' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Almendra Display' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Almendra SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Amarante' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Amaranth' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Amatic SC' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin','vietnamese','hebrew','latin-ext','cyrillic') ),'Amethysta' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Amiko' => array( 'category' => 'sans-serif','styles'=>array('regular','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Amiri' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','arabic','latin-ext') ),'Amita' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Anaheim' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Andada' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Andika' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Angkor' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Annie Use Your Telescope' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Anonymous Pro' => array( 'category' => 'monospace','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext','greek','cyrillic') ),'Antic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Antic Didone' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Antic Slab' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Anton' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Arapey' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Arbutus' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Arbutus Slab' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Architects Daughter' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Archivo' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Archivo Black' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Archivo Narrow' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Aref Ruqaa' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','arabic') ),'Arima Madurai' => array( 'category' => 'display','styles'=>array('100','200','300','regular','500','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext','tamil') ),'Arimo' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','hebrew','latin-ext','greek','cyrillic','greek-ext') ),'Arizonia' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Armata' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Arsenal' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Artifika' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Arvo' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Arya' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Asap' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Asap Condensed' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Asar' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Asset' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Assistant' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','600','700','800'),'subsets'=>array('latin','hebrew') ),'Astloch' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Asul' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Athiti' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Atma' => array( 'category' => 'display','styles'=>array('300','regular','500','600','700'),'subsets'=>array('bengali','latin','latin-ext') ),'Atomic Age' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Aubrey' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Audiowide' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Autour One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Average' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Average Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Averia Gruesa Libre' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Averia Libre' => array( 'category' => 'display','styles'=>array('300','300italic','regular','italic','700','700italic'),'subsets'=>array('latin') ),'Averia Sans Libre' => array( 'category' => 'display','styles'=>array('300','300italic','regular','italic','700','700italic'),'subsets'=>array('latin') ),'Averia Serif Libre' => array( 'category' => 'display','styles'=>array('300','300italic','regular','italic','700','700italic'),'subsets'=>array('latin') ),'Bad Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','cyrillic') ),'Bahiana' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Baloo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('devanagari','latin','vietnamese','latin-ext') ),'Baloo Bhai' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','gujarati','latin-ext') ),'Baloo Bhaijaan' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','arabic','latin-ext') ),'Baloo Bhaina' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','oriya','vietnamese','latin-ext') ),'Baloo Chettan' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','malayalam') ),'Baloo Da' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('bengali','latin','vietnamese','latin-ext') ),'Baloo Paaji' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','gurmukhi') ),'Baloo Tamma' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','kannada') ),'Baloo Tammudu' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('telugu','latin','vietnamese','latin-ext') ),'Baloo Thambi' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','tamil') ),'Balthazar' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Bangers' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Barlow' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Barlow Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Barlow Semi Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Barrio' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Basic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Battambang' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('khmer') ),'Baumans' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Bayon' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Belgrano' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Bellefair' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','hebrew','latin-ext') ),'Belleza' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'BenchNine' => array( 'category' => 'sans-serif','styles'=>array('300','regular','700'),'subsets'=>array('latin','latin-ext') ),'Bentham' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Berkshire Swash' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bevan' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Bigelow Rules' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bigshot One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Bilbo' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bilbo Swash Caps' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'BioRhyme' => array( 'category' => 'serif','styles'=>array('200','300','regular','700','800'),'subsets'=>array('latin','latin-ext') ),'BioRhyme Expanded' => array( 'category' => 'serif','styles'=>array('200','300','regular','700','800'),'subsets'=>array('latin','latin-ext') ),'Biryani' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','600','700','800','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Bitter' => array( 'category' => 'serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','latin-ext') ),'Black And White Picture' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Black Han Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Black Ops One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bokor' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Bonbon' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Boogaloo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Bowlby One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Bowlby One SC' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Brawler' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Bree Serif' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bubblegum Sans' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Bubbler One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Buda' => array( 'category' => 'display','styles'=>array('300'),'subsets'=>array('latin') ),'Buenard' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Bungee' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Bungee Hairline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Bungee Inline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Bungee Outline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Bungee Shade' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Butcherman' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Butterfly Kids' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cabin' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Cabin Condensed' => array( 'category' => 'sans-serif','styles'=>array('regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Cabin Sketch' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Caesar Dressing' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Cagliostro' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Cairo' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','600','700','900'),'subsets'=>array('latin','arabic','latin-ext') ),'Calligraffitti' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Cambay' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('devanagari','latin','latin-ext') ),'Cambo' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Candal' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Cantarell' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Cantata One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cantora One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Capriola' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cardo' => array( 'category' => 'serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','latin-ext','greek','greek-ext') ),'Carme' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Carrois Gothic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Carrois Gothic SC' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Carter One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Catamaran' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','latin-ext','tamil') ),'Caudex' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext','greek','greek-ext') ),'Caveat' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Caveat Brush' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cedarville Cursive' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Ceviche One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Changa' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('latin','arabic','latin-ext') ),'Changa One' => array( 'category' => 'display','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Chango' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Chathura' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','700','800'),'subsets'=>array('telugu','latin') ),'Chau Philomene One' => array( 'category' => 'sans-serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Chela One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Chelsea Market' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Chenla' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Cherry Cream Soda' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Cherry Swash' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Chewy' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Chicle' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Chivo' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','700','700italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Chonburi' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Cinzel' => array( 'category' => 'serif','styles'=>array('regular','700','900'),'subsets'=>array('latin','latin-ext') ),'Cinzel Decorative' => array( 'category' => 'display','styles'=>array('regular','700','900'),'subsets'=>array('latin') ),'Clicker Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Coda' => array( 'category' => 'display','styles'=>array('regular','800'),'subsets'=>array('latin','latin-ext') ),'Coda Caption' => array( 'category' => 'sans-serif','styles'=>array('800'),'subsets'=>array('latin','latin-ext') ),'Codystar' => array( 'category' => 'display','styles'=>array('300','regular'),'subsets'=>array('latin','latin-ext') ),'Coiny' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','tamil') ),'Combo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Comfortaa' => array( 'category' => 'display','styles'=>array('300','regular','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic') ),'Coming Soon' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Concert One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Condiment' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Content' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('khmer') ),'Contrail One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Convergence' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Cookie' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Copse' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Corben' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Cormorant' => array( 'category' => 'serif','styles'=>array('300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cormorant Garamond' => array( 'category' => 'serif','styles'=>array('300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cormorant Infant' => array( 'category' => 'serif','styles'=>array('300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cormorant SC' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cormorant Unicase' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cormorant Upright' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Courgette' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cousine' => array( 'category' => 'monospace','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','hebrew','latin-ext','greek','cyrillic','greek-ext') ),'Coustard' => array( 'category' => 'serif','styles'=>array('regular','900'),'subsets'=>array('latin') ),'Covered By Your Grace' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Crafty Girls' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Creepster' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Crete Round' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Crimson Text' => array( 'category' => 'serif','styles'=>array('regular','italic','600','600italic','700','700italic'),'subsets'=>array('latin') ),'Croissant One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Crushed' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Cuprum' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Cute Font' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Cutive' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Cutive Mono' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Damion' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Dancing Script' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Dangrek' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'David Libre' => array( 'category' => 'serif','styles'=>array('regular','500','700'),'subsets'=>array('latin','vietnamese','hebrew','latin-ext') ),'Dawning of a New Day' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Days One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Dekko' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Delius' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Delius Swash Caps' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Delius Unicase' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Della Respira' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Denk One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Devonshire' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Dhurjati' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Didact Gothic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic','greek-ext') ),'Diplomata' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Diplomata SC' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Do Hyeon' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Dokdo' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Domine' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Donegal One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Doppio One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Dorsa' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Dosis' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('latin','latin-ext') ),'Dr Sugiyama' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Duru Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Dynalight' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'EB Garamond' => array( 'category' => 'serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic','800','800italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Eagle Lake' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'East Sea Dokdo' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Eater' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Economica' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Eczar' => array( 'category' => 'serif','styles'=>array('regular','500','600','700','800'),'subsets'=>array('devanagari','latin','latin-ext') ),'El Messiri' => array( 'category' => 'sans-serif','styles'=>array('regular','500','600','700'),'subsets'=>array('latin','arabic','cyrillic') ),'Electrolize' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Elsie' => array( 'category' => 'display','styles'=>array('regular','900'),'subsets'=>array('latin','latin-ext') ),'Elsie Swash Caps' => array( 'category' => 'display','styles'=>array('regular','900'),'subsets'=>array('latin','latin-ext') ),'Emblema One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Emilys Candy' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Encode Sans' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Encode Sans Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Encode Sans Expanded' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Encode Sans Semi Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Encode Sans Semi Expanded' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Engagement' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Englebert' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Enriqueta' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Erica One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Esteban' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Euphoria Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ewert' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Exo' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Exo 2' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Expletus Sans' => array( 'category' => 'display','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin') ),'Fanwood Text' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Farsan' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','gujarati','latin-ext') ),'Fascinate' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fascinate Inline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Faster One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fasthand' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('khmer') ),'Fauna One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Faustina' => array( 'category' => 'serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Federant' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Federo' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Felipa' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Fenix' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Finger Paint' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fira Mono' => array( 'category' => 'monospace','styles'=>array('regular','500','700'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic','greek-ext') ),'Fira Sans' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Fira Sans Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Fira Sans Extra Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Fjalla One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Fjord One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Flamenco' => array( 'category' => 'display','styles'=>array('300','regular'),'subsets'=>array('latin') ),'Flavors' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fondamento' => array( 'category' => 'handwriting','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Fontdiner Swanky' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Forum' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'Francois One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Frank Ruhl Libre' => array( 'category' => 'serif','styles'=>array('300','regular','500','700','900'),'subsets'=>array('latin','hebrew','latin-ext') ),'Freckle Face' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Fredericka the Great' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fredoka One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Freehand' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Fresca' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Frijole' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Fruktur' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Fugaz One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'GFS Didot' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('greek') ),'GFS Neohellenic' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('greek') ),'Gabriela' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','cyrillic') ),'Gaegu' => array( 'category' => 'handwriting','styles'=>array('300','regular','700'),'subsets'=>array('korean','latin') ),'Gafata' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Galada' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('bengali','latin') ),'Galdeano' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Galindo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Gamja Flower' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Gentium Basic' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Gentium Book Basic' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Geo' => array( 'category' => 'sans-serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Geostar' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Geostar Fill' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Germania One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Gidugu' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Gilda Display' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Give You Glory' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Glass Antiqua' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Glegoo' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Gloria Hallelujah' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Goblin One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Gochi Hand' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Gorditas' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Gothic A1' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('korean','latin') ),'Goudy Bookletter 1911' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Graduate' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Grand Hotel' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Gravitas One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Great Vibes' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Griffy' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Gruppo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Gudea' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','latin-ext') ),'Gugi' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Gurajada' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Habibi' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Halant' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Hammersmith One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Hanalei' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Hanalei Fill' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Handlee' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Hanuman' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('khmer') ),'Happy Monkey' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Harmattan' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','arabic') ),'Headland One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Heebo' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','800','900'),'subsets'=>array('latin','hebrew') ),'Henny Penny' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Herr Von Muellerhoff' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Hi Melody' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Hind' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Hind Guntur' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('telugu','latin','latin-ext') ),'Hind Madurai' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('latin','latin-ext','tamil') ),'Hind Siliguri' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('bengali','latin','latin-ext') ),'Hind Vadodara' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('latin','gujarati','latin-ext') ),'Holtwood One SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Homemade Apple' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Homenaje' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'IBM Plex Mono' => array( 'category' => 'monospace','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'IBM Plex Sans' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'IBM Plex Sans Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'IBM Plex Serif' => array( 'category' => 'serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'IM Fell DW Pica' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'IM Fell DW Pica SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'IM Fell Double Pica' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'IM Fell Double Pica SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'IM Fell English' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'IM Fell English SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'IM Fell French Canon' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'IM Fell French Canon SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'IM Fell Great Primer' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'IM Fell Great Primer SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Iceberg' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Iceland' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Imprima' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Inconsolata' => array( 'category' => 'monospace','styles'=>array('regular','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Inder' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Indie Flower' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Inika' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Inknut Antiqua' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700','800','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Irish Grover' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Istok Web' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'Italiana' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Italianno' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Itim' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Jacques Francois' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Jacques Francois Shadow' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Jaldi' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Jim Nightshade' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Jockey One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Jolly Lodger' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Jomhuria' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','arabic','latin-ext') ),'Josefin Sans' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','300','300italic','regular','italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Josefin Slab' => array( 'category' => 'serif','styles'=>array('100','100italic','300','300italic','regular','italic','600','600italic','700','700italic'),'subsets'=>array('latin') ),'Joti One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Jua' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Judson' => array( 'category' => 'serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Julee' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Julius Sans One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Junge' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Jura' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Just Another Hand' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Just Me Again Down Here' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kadwa' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin') ),'Kalam' => array( 'category' => 'handwriting','styles'=>array('300','regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Kameron' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Kanit' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Kantumruy' => array( 'category' => 'sans-serif','styles'=>array('300','regular','700'),'subsets'=>array('khmer') ),'Karla' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Karma' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Katibeh' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','arabic','latin-ext') ),'Kaushan Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kavivanar' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','tamil') ),'Kavoon' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kdam Thmor' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Keania One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kelly Slab' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Kenia' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Khand' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Khmer' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Khula' => array( 'category' => 'sans-serif','styles'=>array('300','regular','600','700','800'),'subsets'=>array('devanagari','latin','latin-ext') ),'Kirang Haerang' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Kite One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Knewave' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kosugi' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('japanese','latin','cyrillic') ),'Kosugi Maru' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('japanese','latin','cyrillic') ),'Kotta One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Koulen' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Kranky' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Kreon' => array( 'category' => 'serif','styles'=>array('300','regular','700'),'subsets'=>array('latin') ),'Kristi' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Krona One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Kumar One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','gujarati','latin-ext') ),'Kumar One Outline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','gujarati','latin-ext') ),'Kurale' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','devanagari','latin','latin-ext','cyrillic') ),'La Belle Aurore' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Laila' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Lakki Reddy' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Lalezar' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','arabic','latin-ext') ),'Lancelot' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Lateef' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','arabic') ),'Lato' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','300','300italic','regular','italic','700','700italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'League Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Leckerli One' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Ledger' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Lekton' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','latin-ext') ),'Lemon' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Lemonada' => array( 'category' => 'display','styles'=>array('300','regular','600','700'),'subsets'=>array('latin','vietnamese','arabic','latin-ext') ),'Libre Barcode 128' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Barcode 128 Text' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Barcode 39' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Barcode 39 Extended' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Barcode 39 Extended Text' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Barcode 39 Text' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Libre Baskerville' => array( 'category' => 'serif','styles'=>array('regular','italic','700'),'subsets'=>array('latin','latin-ext') ),'Libre Franklin' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Life Savers' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Lilita One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Lily Script One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Limelight' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Linden Hill' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Lobster' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Lobster Two' => array( 'category' => 'display','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Londrina Outline' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Londrina Shadow' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Londrina Sketch' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Londrina Solid' => array( 'category' => 'display','styles'=>array('100','300','regular','900'),'subsets'=>array('latin') ),'Lora' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Love Ya Like A Sister' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Loved by the King' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Lovers Quarrel' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Luckiest Guy' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Lusitana' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Lustria' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'M PLUS 1p' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','800','900'),'subsets'=>array('cyrillic-ext','japanese','latin','vietnamese','hebrew','latin-ext','greek','cyrillic','greek-ext') ),'M PLUS Rounded 1c' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','800','900'),'subsets'=>array('cyrillic-ext','japanese','latin','vietnamese','hebrew','latin-ext','greek','cyrillic','greek-ext') ),'Macondo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Macondo Swash Caps' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Mada' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','900'),'subsets'=>array('latin','arabic') ),'Magra' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Maiden Orange' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Maitree' => array( 'category' => 'serif','styles'=>array('200','300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Mako' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Mallanna' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Mandali' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Manuale' => array( 'category' => 'serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Marcellus' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Marcellus SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Marck Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Margarine' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Markazi Text' => array( 'category' => 'serif','styles'=>array('regular','500','600','700'),'subsets'=>array('latin','vietnamese','arabic','latin-ext') ),'Marko One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Marmelad' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Martel' => array( 'category' => 'serif','styles'=>array('200','300','regular','600','700','800','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Martel Sans' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','600','700','800','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Marvel' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Mate' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Mate SC' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Maven Pro' => array( 'category' => 'sans-serif','styles'=>array('regular','500','700','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'McLaren' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Meddon' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'MedievalSharp' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Medula One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Meera Inimai' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','tamil') ),'Megrim' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Meie Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Merienda' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Merienda One' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Merriweather' => array( 'category' => 'serif','styles'=>array('300','300italic','regular','italic','700','700italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Merriweather Sans' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','700','700italic','800','800italic'),'subsets'=>array('latin','latin-ext') ),'Metal' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Metal Mania' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Metamorphous' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Metrophobic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Michroma' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Milonga' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Miltonian' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Miltonian Tattoo' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Mina' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('bengali','latin','latin-ext') ),'Miniver' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Miriam Libre' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','hebrew','latin-ext') ),'Mirza' => array( 'category' => 'display','styles'=>array('regular','500','600','700'),'subsets'=>array('latin','arabic','latin-ext') ),'Miss Fajardose' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mitr' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Modak' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Modern Antiqua' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mogra' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','gujarati','latin-ext') ),'Molengo' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Molle' => array( 'category' => 'handwriting','styles'=>array('italic'),'subsets'=>array('latin','latin-ext') ),'Monda' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Monofett' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Monoton' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Monsieur La Doulaise' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Montaga' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Montez' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Montserrat' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Montserrat Alternates' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Montserrat Subrayada' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Moul' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Moulpali' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Mountains of Christmas' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Mouse Memoirs' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mr Bedfort' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mr Dafoe' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mr De Haviland' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mrs Saint Delafield' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mrs Sheppards' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Mukta' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('devanagari','latin','latin-ext') ),'Mukta Mahee' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('latin','latin-ext','gurmukhi') ),'Mukta Malar' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('latin','latin-ext','tamil') ),'Mukta Vaani' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','800'),'subsets'=>array('latin','gujarati','latin-ext') ),'Muli' => array( 'category' => 'sans-serif','styles'=>array('200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Mystery Quest' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'NTR' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Nanum Brush Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Nanum Gothic' => array( 'category' => 'sans-serif','styles'=>array('regular','700','800'),'subsets'=>array('korean','latin') ),'Nanum Gothic Coding' => array( 'category' => 'monospace','styles'=>array('regular','700'),'subsets'=>array('korean','latin') ),'Nanum Myeongjo' => array( 'category' => 'serif','styles'=>array('regular','700','800'),'subsets'=>array('korean','latin') ),'Nanum Pen Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Neucha' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','cyrillic') ),'Neuton' => array( 'category' => 'serif','styles'=>array('200','300','regular','italic','700','800'),'subsets'=>array('latin','latin-ext') ),'New Rocker' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'News Cycle' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Niconne' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Nixie One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nobile' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Nokora' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('khmer') ),'Norican' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Nosifer' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Nothing You Could Do' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Noticia Text' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Noto Sans' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','devanagari','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Noto Sans JP' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','900'),'subsets'=>array('japanese','latin') ),'Noto Sans KR' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','900'),'subsets'=>array('korean','latin') ),'Noto Serif' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Noto Serif JP' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','900'),'subsets'=>array('japanese','latin') ),'Noto Serif KR' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700','900'),'subsets'=>array('korean','latin') ),'Nova Cut' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Flat' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Mono' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('latin','greek') ),'Nova Oval' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Round' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Script' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Slim' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Nova Square' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Numans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Nunito' => array( 'category' => 'sans-serif','styles'=>array('200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Nunito Sans' => array( 'category' => 'sans-serif','styles'=>array('200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Odor Mean Chey' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Offside' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Old Standard TT' => array( 'category' => 'serif','styles'=>array('regular','italic','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Oldenburg' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Oleo Script' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Oleo Script Swash Caps' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Open Sans' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','600','600italic','700','700italic','800','800italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Open Sans Condensed' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Oranienbaum' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'Orbitron' => array( 'category' => 'sans-serif','styles'=>array('regular','500','700','900'),'subsets'=>array('latin') ),'Oregano' => array( 'category' => 'display','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Orienta' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Original Surfer' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Oswald' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Over the Rainbow' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Overlock' => array( 'category' => 'display','styles'=>array('regular','italic','700','700italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Overlock SC' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Overpass' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Overpass Mono' => array( 'category' => 'monospace','styles'=>array('300','regular','600','700'),'subsets'=>array('latin','latin-ext') ),'Ovo' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Oxygen' => array( 'category' => 'sans-serif','styles'=>array('300','regular','700'),'subsets'=>array('latin','latin-ext') ),'Oxygen Mono' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'PT Mono' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'PT Sans' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'PT Sans Caption' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'PT Sans Narrow' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'PT Serif' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'PT Serif Caption' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'Pacifico' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Padauk' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','myanmar') ),'Palanquin' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Palanquin Dark' => array( 'category' => 'sans-serif','styles'=>array('regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Pangolin' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Paprika' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Parisienne' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Passero One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Passion One' => array( 'category' => 'display','styles'=>array('regular','700','900'),'subsets'=>array('latin','latin-ext') ),'Pathway Gothic One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Patrick Hand' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Patrick Hand SC' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Pattaya' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','thai','cyrillic') ),'Patua One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Pavanam' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','tamil') ),'Paytone One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Peddana' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Peralta' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Permanent Marker' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Petit Formal Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Petrona' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Philosopher' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','cyrillic') ),'Piedra' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Pinyon Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Pirata One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Plaster' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Play' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic') ),'Playball' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Playfair Display' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Playfair Display SC' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Podkova' => array( 'category' => 'serif','styles'=>array('regular','500','600','700','800'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Poiret One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Poller One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Poly' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin') ),'Pompiere' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Pontano Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Poor Story' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Poppins' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('devanagari','latin','latin-ext') ),'Port Lligat Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Port Lligat Slab' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Pragati Narrow' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Prata' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','vietnamese','cyrillic') ),'Preahvihear' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Press Start 2P' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic') ),'Pridi' => array( 'category' => 'serif','styles'=>array('200','300','regular','500','600','700'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Princess Sofia' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Prociono' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Prompt' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Prosto One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Proza Libre' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','500','500italic','600','600italic','700','700italic','800','800italic'),'subsets'=>array('latin','latin-ext') ),'Puritan' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Purple Purse' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Quando' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Quantico' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Quattrocento' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Quattrocento Sans' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Questrial' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Quicksand' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','700'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Quintessential' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Qwigley' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Racing Sans One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Radley' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Rajdhani' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Rakkas' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','arabic','latin-ext') ),'Raleway' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Raleway Dots' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ramabhadra' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Ramaraja' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Rambla' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Rammetto One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ranchers' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Rancho' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Ranga' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Rasa' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('latin','gujarati','latin-ext') ),'Rationale' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Ravi Prakash' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Redressed' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Reem Kufi' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','arabic') ),'Reenie Beanie' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Revalia' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Rhodium Libre' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Ribeye' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ribeye Marrow' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Righteous' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Risque' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Roboto' => array( 'category' => 'sans-serif','styles'=>array('100','100italic','300','300italic','regular','italic','500','500italic','700','700italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Roboto Condensed' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Roboto Mono' => array( 'category' => 'monospace','styles'=>array('100','100italic','300','300italic','regular','italic','500','500italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Roboto Slab' => array( 'category' => 'serif','styles'=>array('100','300','regular','700'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Rochester' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Rock Salt' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Rokkitt' => array( 'category' => 'serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Romanesco' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ropa Sans' => array( 'category' => 'sans-serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Rosario' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Rosarivo' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Rouge Script' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Rozha One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Rubik' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','500','500italic','700','700italic','900','900italic'),'subsets'=>array('latin','hebrew','latin-ext','cyrillic') ),'Rubik Mono One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Ruda' => array( 'category' => 'sans-serif','styles'=>array('regular','700','900'),'subsets'=>array('latin','latin-ext') ),'Rufina' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Ruge Boogie' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ruluko' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Rum Raisin' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Ruslan Display' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Russo One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Ruthie' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Rye' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sacramento' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sahitya' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin') ),'Sail' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Saira' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Saira Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Saira Extra Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Saira Semi Condensed' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Salsa' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Sanchez' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Sancreek' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sansita' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Sarala' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Sarina' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sarpanch' => array( 'category' => 'sans-serif','styles'=>array('regular','500','600','700','800','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Satisfy' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Sawarabi Gothic' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('japanese','latin','vietnamese','latin-ext','cyrillic') ),'Sawarabi Mincho' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('japanese','latin','latin-ext') ),'Scada' => array( 'category' => 'sans-serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','cyrillic') ),'Scheherazade' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('latin','arabic') ),'Schoolbell' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Scope One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Seaweed Script' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Secular One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','hebrew','latin-ext') ),'Sedgwick Ave' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Sedgwick Ave Display' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Sevillana' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Seymour One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Shadows Into Light' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Shadows Into Light Two' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Shanti' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Share' => array( 'category' => 'display','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Share Tech' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Share Tech Mono' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('latin') ),'Shojumaru' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Short Stack' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Shrikhand' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','gujarati','latin-ext') ),'Siemreap' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Sigmar One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Signika' => array( 'category' => 'sans-serif','styles'=>array('300','regular','600','700'),'subsets'=>array('latin','latin-ext') ),'Signika Negative' => array( 'category' => 'sans-serif','styles'=>array('300','regular','600','700'),'subsets'=>array('latin','latin-ext') ),'Simonetta' => array( 'category' => 'display','styles'=>array('regular','italic','900','900italic'),'subsets'=>array('latin','latin-ext') ),'Sintony' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Sirin Stencil' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Six Caps' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Skranji' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),'Slabo 13px' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Slabo 27px' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Slackey' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Smokum' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Smythe' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Sniglet' => array( 'category' => 'display','styles'=>array('regular','800'),'subsets'=>array('latin','latin-ext') ),'Snippet' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Snowburst One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sofadi One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Sofia' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Song Myung' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Sonsie One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Sorts Mill Goudy' => array( 'category' => 'serif','styles'=>array('regular','italic'),'subsets'=>array('latin','latin-ext') ),'Source Code Pro' => array( 'category' => 'monospace','styles'=>array('200','300','regular','500','600','700','900'),'subsets'=>array('latin','latin-ext') ),'Source Sans Pro' => array( 'category' => 'sans-serif','styles'=>array('200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic','greek-ext') ),'Source Serif Pro' => array( 'category' => 'serif','styles'=>array('regular','600','700'),'subsets'=>array('latin','latin-ext') ),'Space Mono' => array( 'category' => 'monospace','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Special Elite' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Spectral' => array( 'category' => 'serif','styles'=>array('200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Spectral SC' => array( 'category' => 'serif','styles'=>array('200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Spicy Rice' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Spinnaker' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Spirax' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Squada One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Sree Krushnadevaraya' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Sriracha' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Stalemate' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Stalinist One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Stardos Stencil' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Stint Ultra Condensed' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Stint Ultra Expanded' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Stoke' => array( 'category' => 'serif','styles'=>array('300','regular'),'subsets'=>array('latin','latin-ext') ),'Strait' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Stylish' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Sue Ellen Francisco' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Suez One' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','hebrew','latin-ext') ),'Sumana' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Sunflower' => array( 'category' => 'sans-serif','styles'=>array('300','500','700'),'subsets'=>array('korean','latin') ),'Sunshiney' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Supermercado One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Sura' => array( 'category' => 'serif','styles'=>array('regular','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Suranna' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Suravaram' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Suwannaphum' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Swanky and Moo Moo' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Syncopate' => array( 'category' => 'sans-serif','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Tajawal' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','500','700','800','900'),'subsets'=>array('latin','arabic') ),'Tangerine' => array( 'category' => 'handwriting','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Taprom' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('khmer') ),'Tauri' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Taviraj' => array( 'category' => 'serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Teko' => array( 'category' => 'sans-serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('devanagari','latin','latin-ext') ),'Telex' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Tenali Ramakrishna' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Tenor Sans' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Text Me One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'The Girl Next Door' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Tienne' => array( 'category' => 'serif','styles'=>array('regular','700','900'),'subsets'=>array('latin') ),'Tillana' => array( 'category' => 'handwriting','styles'=>array('regular','500','600','700','800'),'subsets'=>array('devanagari','latin','latin-ext') ),'Timmana' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('telugu','latin') ),'Tinos' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','hebrew','latin-ext','greek','cyrillic','greek-ext') ),'Titan One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Titillium Web' => array( 'category' => 'sans-serif','styles'=>array('200','200italic','300','300italic','regular','italic','600','600italic','700','700italic','900'),'subsets'=>array('latin','latin-ext') ),'Trade Winds' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Trirong' => array( 'category' => 'serif','styles'=>array('100','100italic','200','200italic','300','300italic','regular','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'),'subsets'=>array('latin','vietnamese','latin-ext','thai') ),'Trocchi' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Trochut' => array( 'category' => 'display','styles'=>array('regular','italic','700'),'subsets'=>array('latin') ),'Trykker' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Tulpen One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Ubuntu' => array( 'category' => 'sans-serif','styles'=>array('300','300italic','regular','italic','500','500italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic','greek-ext') ),'Ubuntu Condensed' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic','greek-ext') ),'Ubuntu Mono' => array( 'category' => 'monospace','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('cyrillic-ext','latin','latin-ext','greek','cyrillic','greek-ext') ),'Ultra' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Uncial Antiqua' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Underdog' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext','cyrillic') ),'Unica One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'UnifrakturCook' => array( 'category' => 'display','styles'=>array('700'),'subsets'=>array('latin') ),'UnifrakturMaguntia' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Unkempt' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin') ),'Unlock' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Unna' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'VT323' => array( 'category' => 'monospace','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','latin-ext') ),'Vampiro One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Varela' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Varela Round' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','vietnamese','hebrew','latin-ext') ),'Vast Shadow' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Vesper Libre' => array( 'category' => 'serif','styles'=>array('regular','500','700','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Vibur' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Vidaloka' => array( 'category' => 'serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Viga' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Voces' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Volkhov' => array( 'category' => 'serif','styles'=>array('regular','italic','700','700italic'),'subsets'=>array('latin') ),'Vollkorn' => array( 'category' => 'serif','styles'=>array('regular','italic','600','600italic','700','700italic','900','900italic'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','greek','cyrillic') ),'Vollkorn SC' => array( 'category' => 'serif','styles'=>array('regular','600','700','900'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Voltaire' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Waiting for the Sunrise' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Wallpoet' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin') ),'Walter Turncoat' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Warnes' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Wellfleet' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Wendy One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin','latin-ext') ),'Wire One' => array( 'category' => 'sans-serif','styles'=>array('regular'),'subsets'=>array('latin') ),'Work Sans' => array( 'category' => 'sans-serif','styles'=>array('100','200','300','regular','500','600','700','800','900'),'subsets'=>array('latin','latin-ext') ),'Yanone Kaffeesatz' => array( 'category' => 'sans-serif','styles'=>array('200','300','regular','700'),'subsets'=>array('latin','vietnamese','latin-ext','cyrillic') ),'Yantramanav' => array( 'category' => 'sans-serif','styles'=>array('100','300','regular','500','700','900'),'subsets'=>array('devanagari','latin','latin-ext') ),'Yatra One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('devanagari','latin','latin-ext') ),'Yellowtail' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Yeon Sung' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('korean','latin') ),'Yeseva One' => array( 'category' => 'display','styles'=>array('regular'),'subsets'=>array('cyrillic-ext','latin','vietnamese','latin-ext','cyrillic') ),'Yesteryear' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Yrsa' => array( 'category' => 'serif','styles'=>array('300','regular','500','600','700'),'subsets'=>array('latin','latin-ext') ),'Zeyada' => array( 'category' => 'handwriting','styles'=>array('regular'),'subsets'=>array('latin') ),'Zilla Slab' => array( 'category' => 'serif','styles'=>array('300','300italic','regular','italic','500','500italic','600','600italic','700','700italic'),'subsets'=>array('latin','latin-ext') ),'Zilla Slab Highlight' => array( 'category' => 'display','styles'=>array('regular','700'),'subsets'=>array('latin','latin-ext') ),);
        
    return apply_filters( 'fox_google_fonts', $fonts );

}
endif;

if ( ! function_exists( 'fox_option_fonts' ) ) :
/**
 * Returns font array used for customization
 *
 * @since 1.0
 */
function fox_option_fonts() {
    $fontArr = array();
    foreach ( fox_normal_fonts() as $font => $val ) {
        $fontArr[ $font ] = $font;
    }
    foreach ( fox_google_fonts() as $font => $val ) {
        $fontArr[ $font ] = $font;
    }
    return $fontArr;
}
endif;

if ( ! function_exists( 'fox_font_array' ) ) :
/**
 * Font Array
 *
 * @since 1.0
 */
function fox_font_array() {
    
    return array_keys( array_merge( fox_normal_fonts(), fox_google_fonts() ) );
    
}
endif;