<?php
/* Admin Area
-------------------------------------------------------------------------------------- */
/**
 * Admin Class
 *
 * @since Fox 2.2
 */
if ( !class_exists( 'Wi_Admin' ) ) :

class Wi_Admin
{   
    
    /**
	 *
	 */
	public function __construct() {
	}
    
    /**
	 * The one instance of Wi_Admin
	 *
	 * @since Fox 2.2
	 */
	private static $instance;

	/**
	 * Instantiate or return the one Wi_Admin instance
	 *
	 * @since Fox 2.2
	 *
	 * @return Wi_Admin
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
    
    /**
     * Initiate the class
     * contains action & filters
     *
     * @since Fox 2.2
     */
    public function init() {
        
        // metabox
        require_once get_template_directory() . '/inc/admin/framework/metabox/metabox.php';
        
        // TGM
        require_once get_template_directory() . '/inc/admin/framework/tgm.php';
        
        // Post Format UI
        require_once get_template_directory() . '/inc/admin/framework/formatui/vp-post-formats-ui.php'; // This plugin has a high compatible ability so we don't
        
        // correct the post format-ui url
        add_filter( 'vp_pfui_base_url', array( $this, 'vp_pfui_base_url' ) );
        
        // https://gist.github.com/ayublin/8818074
        add_action( 'vp_pfui_after_gallery_meta', array( $this, 'add_gallery_effect_field' ) );
        
        // handle the saving of our new field
        add_action( 'admin_init' , array( $this, 'add_gallery_effect_field_init' ) );
        
        // register plugins needed for theme
        add_action( 'tgmpa_register', array ( $this, 'register_required_plugins' ) );
        
        // Include media upload to sidebar area
        // This will be used when we need to upload something
        add_action( 'sidebar_admin_setup', array( $this, 'wp_enqueue_media' ) );
        
        require_once get_template_directory() . '/inc/admin/framework/nav/nav-custom-fields.php'; // fields
        add_action( 'wp_loaded', array( $this, 'include_menu_walker' ) );
        
        // enqueue scripts
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
        
        // localization
        add_action( 'wiadminjs', array( $this, 'l10n' ) );
        
        // metabox
        add_action( 'wi_metaboxes', array( $this, 'metaboxes' ) );
        
        /**
         * Add a thumbnail column in edit.php
         *
         * Thank to: http://wordpress.org/support/topic/adding-custum-post-type-thumbnail-to-the-edit-screen
         *
         * @since 1.0
         */
        add_action( 'manage_posts_custom_column', array( $this, 'add_thumbnail_value_editscreen' ), 10, 2 );
        add_filter( 'manage_edit-post_columns', array( $this, 'columns_filter' ) , 10, 1 );
        
        /**
         * Term Options
         */
        add_action( 'category_add_form_fields', array( $this, 'taxonomy_add_new_meta_field' ), 10, 2 );
        add_action( 'post_tag_add_form_fields', array( $this, 'taxonomy_add_new_meta_field' ), 10, 2 );
        
        add_action( 'category_edit_form_fields', array( $this, 'taxonomy_edit_meta_field' ), 10, 2 );
        add_action( 'post_tag_edit_form_fields', array( $this, 'taxonomy_edit_meta_field' ), 10, 2 );
        
        add_action( 'edited_category', array( $this, 'save_taxonomy_custom_meta' ), 10, 2 );  
        add_action( 'create_category', array( $this, 'save_taxonomy_custom_meta' ), 10, 2 );  
        add_action( 'edited_post_tag', array( $this, 'save_taxonomy_custom_meta' ), 10, 2 );  
        add_action( 'create_post_tag', array( $this, 'save_taxonomy_custom_meta' ), 10, 2 );
    }
    
    function save_taxonomy_custom_meta( $term_id ) {
        
        if ( isset( $_POST['term_meta'] ) ) {
            $t_id = $term_id;
            $term_meta = get_option( "taxonomy_$t_id" );
            $cat_keys = array_keys( $_POST['term_meta'] );
            foreach ( $cat_keys as $key ) {
                if ( isset ( $_POST['term_meta'][$key] ) ) {
                    $term_meta[$key] = $_POST['term_meta'][$key];
                }
            }
            // Save the option array.
            update_option( "taxonomy_$t_id", $term_meta );
        }
        
    }
    
    function taxonomy_add_new_meta_field() {
        // this will add the custom meta field to the add new term page

        $layout_arr = wi_layout_array();
        $layout_arr = array( '' => 'Default' ) + $layout_arr;
        $sidebar_state_arr = wi_sidebar_array();
        $sidebar_state_arr = array( '' => 'Default' ) + $sidebar_state_arr;

        ?>
        <tr class="form-field">
           <th scope="row" valign="top"><label for="term_meta[layout]"><?php _e( 'Select layout', 'wi' ); ?></label></th>
            <td>
                <select name="term_meta[layout]" id="term_meta[layout]">
                    <?php foreach ($layout_arr as $lay => $out): ?>
                    <option value="<?php echo esc_attr($lay);?>"><?php echo esc_html($out);?></option>
                    <?php endforeach; ?>
                </select>
                <p class="description"><?php _e( 'Select layout for displaying posts on this category','wi' ); ?></p>
            </td>
        </tr>

        <tr class="form-field">
           <th scope="row" valign="top"><label for="term_meta[sidebar_state]"><?php _e( 'Sidebar layout', 'wi' ); ?></label></th>
            <td>
                <select name="term_meta[sidebar_state]" id="term_meta[sidebar_state]">
                    <?php foreach ($sidebar_state_arr as $side => $bar ): ?>
                    <option value="<?php echo esc_attr($side);?>"><?php echo esc_html($bar);?></option>
                    <?php endforeach; ?>
                </select>
                <p class="description"><?php _e( 'Select sidebar layout for  this category','wi' ); ?></p>
            </td>
        </tr>
    <?php
    }
    
    // Edit term page
    function taxonomy_edit_meta_field( $term ) {

        $layout_arr = wi_layout_array();
        $layout_arr = array( '' => 'Default' ) + $layout_arr;
        $sidebar_state_arr = wi_sidebar_array();
        $sidebar_state_arr = array( '' => 'Default' ) + $sidebar_state_arr;

        // put the term ID into a variable
        $t_id = $term->term_id;

        // retrieve the existing value(s) for this meta field. This returns an array
        $term_meta = get_option( "taxonomy_$t_id" );
        $current_layout = isset($term_meta['layout']) ? $term_meta['layout'] : '';
        $current_sidebar_state = isset($term_meta['sidebar_state']) ? $term_meta['sidebar_state'] : '';
    ?>
        <tr class="form-field">
           <th scope="row" valign="top"><label for="term_meta[layout]"><?php _e( 'Select layout', 'wi' ); ?></label></th>
            <td>
                <select name="term_meta[layout]" id="term_meta[layout]">
                    <?php foreach ($layout_arr as $lay => $out): ?>
                    <option value="<?php echo esc_attr($lay);?>" <?php selected( $lay, $current_layout); ?>><?php echo esc_html($out);?></option>
                    <?php endforeach; ?>
                </select>
                <p class="description"><?php _e( 'Select layout for displaying posts on this category','wi' ); ?></p>
            </td>
        </tr>

        <tr class="form-field">
           <th scope="row" valign="top"><label for="term_meta[sidebar_state]"><?php _e( 'Sidebar layout', 'wi' ); ?></label></th>
            <td>
                <select name="term_meta[sidebar_state]" id="term_meta[sidebar_state]">
                    <?php foreach ($sidebar_state_arr as $side => $bar ): ?>
                    <option value="<?php echo esc_attr($side);?>" <?php selected( $side, $current_sidebar_state); ?>><?php echo esc_html($bar);?></option>
                    <?php endforeach; ?>
                </select>
                <p class="description"><?php _e( 'Select sidebar layout for  this category','wi' ); ?></p>
            </td>
        </tr>

    <?php
    }
    
    function add_gallery_effect_field_init() {
        
        $post_formats = get_theme_support('post-formats');
        if (!empty($post_formats[0]) && is_array($post_formats[0])) {
            if (in_array('gallery', $post_formats[0])) {
                add_action('save_post', array( $this, 'format_gallery_save_post' ) );
            }
        }
        
    }

    function add_gallery_effect_field() {
        global $post;
        $effect = get_post_meta($post->ID, '_format_gallery_effect', true);
        if ($effect!='fade' && $effect!='carousel') $effect = 'slide';
        ?>
        <div class="vp-pfui-elm-block" style="padding-left:2px; margin-bottom:10px;">

            <label for="vp-pfui-format-gallery-type" style="padding-left:0; margin-bottom:10px;"><?php _e('Gallery Style', 'wi'); ?></label>

            <input type="radio" name="_format_gallery_effect" value="slide" id="slide" <?php checked( $effect, "slide" ); ?>>
            <label style="display:inline-block;padding-right: 20px;margin-bottom: 4px;padding-left:4px;" for="slide"><?php _e('Slide Slider','wi');?></label>

            <input type="radio" name="_format_gallery_effect" value="fade" id="fade" <?php checked( $effect, "fade" ); ?>>
            <label style="display:inline-block;padding-right:20px;margin-bottom: 4px;padding-left:4px;" for="fade"><?php _e('Fade Slider','wi');?></label>

            <input type="radio" name="_format_gallery_effect" value="carousel" id="carousel" <?php checked( $effect, "carousel" ); ?>>
            <label style="display:inline-block;padding-right: 20px;margin-bottom: 4px;padding-left:4px;" for="carousel"><?php _e('Carousel','wi');?></label>

        </div>
        <?php
    }
    
    function format_gallery_save_post($post_id) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        if (!defined('XMLRPC_REQUEST') && isset($_POST['_format_gallery_effect'])) {
            update_post_meta($post_id, '_format_gallery_effect', $_POST['_format_gallery_effect']);
        }
    }
    
    function add_thumbnail_value_editscreen($column_name, $post_id) {

        $width = (int) 50;
        $height = (int) 50;

        if ( 'thumbnail' == $column_name ) {
            // thumbnail of WP 2.9
            $thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
            // image from gallery
            $attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );
            if ($thumbnail_id)
                $thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
            elseif ($attachments) {
                foreach ( $attachments as $attachment_id => $attachment ) {
                    $thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
                }
            }
            if ( isset($thumb) && $thumb ) {
                echo $thumb;
            } else {
                echo '<em>' . __('None','wi') . '</em>';
            }
        }
    }
    
    function columns_filter( $columns ) {
        $column_thumbnail = array( 'thumbnail' => __('Thumbnail','wi') );
        $columns = array_slice( $columns, 0, 1, true ) + $column_thumbnail + array_slice( $columns, 1, NULL, true );
        return $columns;
    }
    
    /**
     * Register Plugins
     *
     * Instagram Widget & Post Format UI is now a part of Theme package
     *
     * @since 1.0
     */
    function register_required_plugins (){
        
        $plugins = array (
            
            array(
                'name'     				=> 'Contact Form 7', // The plugin name
                'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
                'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
            ),
            
            array(
                'name'     				=> 'Post Views Counter', // The plugin name
                'slug'     				=> 'post-views-counter', // The plugin slug (typically the folder name)
                'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
            ),
            
            array(
                'name'     				=> 'Mailchimp for WP', // The plugin name
                'slug'     				=> 'mailchimp-for-wp', // The plugin slug (typically the folder name)
                'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
            ),
            
            /**
             * this is no longer recommended since 2.8
             *
            array(
                'name'     				=> 'Instagram Widget', // The plugin name
                'slug'     				=> 'wp-instagram-widget', // The plugin slug (typically the folder name)
                'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
            ),
            */
            
            /**
             * this is no longer recommended since 2.8
             *
            array(
                'name'     				=> 'Display Tweets', // The plugin name
                'slug'     				=> 'display-tweets-php', // The plugin slug (typically the folder name)
                'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
            ),
            */
            
        );

        $config = array(
            'id'           => 'tgmpa',
            'default_path' => '',
            'menu'         => 'tgma-install-plugins',
            'parent_slug'  => 'themes.php',
            'capability'   => 'edit_theme_options',
            'has_notices'  => true,
            'dismissable'  => true,
            'dismiss_msg'  => '',
            'is_automatic' => true,
            'message'      => '',
        );

        tgmpa( $plugins, $config );
    }
    
    function vp_pfui_base_url( $url ) {
        return get_template_directory_uri() . '/inc/admin/framework/formatui/';
    }
    
    function wp_enqueue_media() {
        wp_enqueue_media();
    }
    
    /**
     * Includes menu walker
     *
     * @since 2.8
     */
    function include_menu_walker() {
    
        add_filter( 'wp_edit_nav_menu_walker', array( $this, 'load_menu_walker' ), 99 );
        
    }
    
    /**
     * Loads menu walker
     *
     * @since 2.8
     */
    function load_menu_walker( $walker ) {
    
        $walker = 'Fox_Menu_Item_Custom_Fields_Walker';
        if ( ! class_exists( $walker ) ) {
            require_once get_template_directory() . '/inc/admin/framework/nav/walker-nav-menu-edit.php'; // custom walker to add fields
        }

        return $walker;
        
    }
    
    /**
     * Enqueue javascript & style for admin
     *
     * @since Fox 2.2
     */
    function enqueue(){
        
        // We need to upload image/media constantly
        wp_enqueue_media();
        
        // admin css
        wp_enqueue_style( 'wi-admin', get_template_directory_uri() . '/css/admin.css', array( 'wp-color-picker', 'wp-mediaelement' ) );
        
        // admin javascript
        wp_enqueue_script( 'wi-admin', get_template_directory_uri() . '/js/admin.js', array( 'wp-color-picker', 'wp-mediaelement' ), '20160326', true );
        
        // localize javascript
        $jsdata = apply_filters( 'wiadminjs', array() );
        wp_localize_script( 'wi-admin', 'WITHEMES_ADMIN' , $jsdata );
        
    }
    
    /**
     * Localization some text
     *
     * @since Fox 2.2
     */
    function l10n( $jsdata ) {
    
        $jsdata[ 'l10n' ] =  array(
        
            'choose_image' => esc_html__( 'Choose Image', 'wi' ),
            'change_image' => esc_html__( 'Change Image', 'wi' ),
            'upload_image' => esc_html__( 'Upload Image', 'wi' ),
            
            'choose_images' => esc_html__( 'Choose Images', 'wi' ),
            'change_images' => esc_html__( 'Change Images', 'wi' ),
            'upload_images' => esc_html__( 'Upload Images', 'wi' ),
        
        );
        
        return $jsdata;
    
    }
    
    /**
     * Metaboxes
     *
     * @return $metaboxes
     *
     * @modified since 2.4
     * @since Fox 2.2
     */
    function metaboxes( $metaboxes ) {
    
        $metaboxes[] = array (
            
            'id' => 'page-options',
            'screen' => array( 'page' ),
            'title' => esc_html__( 'Settings', 'wi' ),
            'fields' => array(
                
                array(
                    'id' => 'column_layout',
                    'name' => esc_html__( 'Column Layout', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'single-column' => esc_html__( 'Single-column', 'wi' ),
                        'two-column' => esc_html__( 'Two-column', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'sidebar_layout',
                    'name' => esc_html__( 'Sidebar layout', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'sidebar-right' => esc_html__( 'Sidebar right', 'wi' ),
                        'sidebar-left' => esc_html__( 'Sidebar left', 'wi' ),
                        'no-sidebar' => esc_html__( 'No sidebar', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'dropcap',
                    'name' => esc_html__( 'First letter dropcap', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'true' => esc_html__( 'Enable', 'wi' ),
                        'false' => esc_html__( 'Disable', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'disable_share',
                    'name' => esc_html__( 'Hide share icons this page', 'wi' ),
                    'type' => 'checkbox',
                ),
                
            ),
        
        );
        
        $metaboxes[] = array (
            
            'id' => 'post-options',
            'screen' => array( 'post' ),
            'title' => esc_html__( 'Settings', 'wi' ),
            'fields' => array(
                
                array(
                    'id' => 'column_layout',
                    'name' => esc_html__( 'Column Layout', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'single-column' => esc_html__( 'Single-column', 'wi' ),
                        'two-column' => esc_html__( 'Two-column', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'sidebar_layout',
                    'name' => esc_html__( 'Sidebar layout', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'sidebar-right' => esc_html__( 'Sidebar right', 'wi' ),
                        'sidebar-left' => esc_html__( 'Sidebar left', 'wi' ),
                        'no-sidebar' => esc_html__( 'No sidebar', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'dropcap',
                    'name' => esc_html__( 'First letter dropcap', 'wi' ),
                    'type' => 'select',
                    'options' => array(
                        '' => esc_html__( 'Default', 'wi' ),
                        'true' => esc_html__( 'Enable', 'wi' ),
                        'false' => esc_html__( 'Disable', 'wi' ),
                    ),
                    'std' => '',
                ),
                
                array(
                    'id' => 'cool',
                    'name' => 'Make this post "COOL"',
                    'type' => 'checkbox',
                    'desc' => 'When check this, it displays a post with big hero header, narrow content width.',
                ),
                
            ),
        
        );
        
        $metaboxes[] = array (
            
            'id' => 'reiview-options',
            'screen' => array( 'post' ),
            'title' => esc_html__( 'Review Settings', 'wi' ),
            'fields' => array(
                
                array(
                    'id' => 'review',
                    'name' => esc_html__( 'Review', 'wi' ),
                    'type' => 'review',
                ),
                
                array(
                    'id' => 'review_text',
                    'name' => esc_html__( 'Custom Text', 'wi' ),
                    'type' => 'textarea',
                ),
                
                array(
                    'id' => 'review_btn1_url',
                    'name' => esc_html__( 'Button 1 URL', 'wi' ),
                    'type' => 'text',
                    'placeholder' => 'http://',
                ),
                
                array(
                    'id' => 'review_btn1_text',
                    'name' => esc_html__( 'Button 1 Text', 'wi' ),
                    'type' => 'text',
                    'placeholder' => 'Click Here',
                ),
                
                array(
                    'id' => 'review_btn2_url',
                    'name' => esc_html__( 'Button 2 URL', 'wi' ),
                    'type' => 'text',
                    'placeholder' => 'http://',
                ),
                
                array(
                    'id' => 'review_btn2_text',
                    'name' => esc_html__( 'Button 2 Text', 'wi' ),
                    'type' => 'text',
                    'placeholder' => 'Click Here',
                ),
            
            ),
        
        );
        
        return $metaboxes;
    
    }
    
}

Wi_Admin::instance()->init();

endif; // class exists