/**
 * WordPress dependencies
 */
import { __, sprintf } from '@wordpress/i18n';
import { RawHTML } from '@wordpress/element';
import { Modal } from '@wordpress/components';
import { compose, withState } from '@wordpress/compose';

/**
 * Internal dependencies
 */
import Header, { Title } from '../../components/card/header';
import { FooterSchemaActions } from '../../components/card/footer';
import { SiteScanResults } from '@ithemes/security-components';

function ScanOnly( { card, config, scanResults, setState } ) {
	return (
		<div className="itsec-card--type-malware-scan itsec-card--type-malware--scan-only">
			<Header>
				<Title card={ card } config={ config } />
			</Header>
			<section className="itsec-card-malware-scan__description">
				<p>
					<RawHTML>
						{ sprintf(
							__( 'This %1$ssite scan is powered by iThemes%2$s. We use several datapoints to check for known malware, blocklist status, website errors and out-of-date software. These datapoints are not 100%% accurate, but we try our best to provide thorough results.', 'it-l10n-ithemes-security-pro' ),
							'<a href="https://help.ithemes.com/hc/en-us/articles/360046334433">',
							'</a>'
						) }
					</RawHTML>
				</p>
				<p>
					{ __( 'Enable Database Logging to see a history of completed Site Scans.', 'it-l10n-ithemes-security-pro' ) }
				</p>
			</section>
			<FooterSchemaActions card={ card } onComplete={ ( href, response ) => href.endsWith( '/scan' ) && setState( { scanResults: response } ) } />
			{ scanResults && (
				<Modal
					title={ __( 'Scan Results', 'it-l10n-ithemes-security-pro' ) }
					onRequestClose={ () => setState( { scanResults: undefined } ) }
				>
					<SiteScanResults results={ scanResults } showSiteUrl={ false } />
				</Modal>
			) }
		</div>
	);
}

export default compose( [
	withState( { scanResults: undefined } ),
] )( ScanOnly );
